/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.InflaterInputStream;

public final class HashUtils {
    public static HashCode getSha1Hash(byte[] fileContent) {
        Preconditions.checkNotNull(fileContent);
        HashFunction sha1Hasher = Hashing.sha1();
        HashCode fileHashCode = sha1Hasher.hashBytes(fileContent);
        return fileHashCode;
    }

    public static HashCode hashFile(Path file) throws IOException {
        return HashUtils.hashByteSource(com.google.common.io.Files.asByteSource(file.toFile()));
    }

    public static HashCode hashByteSource(ByteSource source) throws IOException {
        return source.hash(Hashing.sha1());
    }

    public static HashCode hashCompressedFile(final Path file) throws IOException {
        ByteSource compressed = new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return new InflaterInputStream(Files.newInputStream(file, new OpenOption[0]));
            }
        };
        return HashUtils.hashByteSource(compressed);
    }
}

