/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;

public class StringBooleanConverter {
    private static final ImmutableSet<String> ENABLED = ImmutableSet.of("true", "on", "enabled", "yes");
    private static final ImmutableSet<String> DISABLED = ImmutableSet.of("false", "off", "disabled", "no");
    private static final ImmutableSet<String> DEFAULTS = ImmutableSet.of("", "default");

    public static boolean stringToBoolean(String value) throws InvalidOptionException {
        if (ENABLED.contains(value.toLowerCase())) {
            return true;
        }
        if (DISABLED.contains(value.toLowerCase())) {
            return false;
        }
        throw new InvalidOptionException("'" + value + "' is not a boolean value.");
    }

    public static Optional<Boolean> stringToOptionalBoolean(String value) throws InvalidOptionException {
        if (ENABLED.contains(value.toLowerCase())) {
            return Optional.of(true);
        }
        if (DISABLED.contains(value.toLowerCase())) {
            return Optional.of(false);
        }
        if (DEFAULTS.contains(value.toLowerCase())) {
            return Optional.absent();
        }
        throw new InvalidOptionException("'" + value + "' is neither a boolean value nor 'default'.");
    }
}

