/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TableFormatter {
    private static final int MINIMAL_COLUMN_LENGTH = 1;
    private static final int COLUMN_SPACER = 1;
    private final int offset;
    private final int columns;
    private final List<List<String>> rows = Lists.newArrayList();

    public TableFormatter(int columns, int offset) {
        Preconditions.checkArgument(offset >= 0, "The offset is negative (%s)", offset);
        this.offset = offset;
        Preconditions.checkArgument(columns > 0, "Number of columns invalid: %s", columns);
        this.columns = columns;
    }

    public void addRow(Object ... elements) {
        Preconditions.checkArgument(elements.length == this.columns, "Incorrect number of elements: %s", elements.length);
        ArrayList<String> row = Lists.newArrayList();
        for (Object element : elements) {
            row.add(element.toString());
        }
        this.rows.add(row);
    }

    public String buildTable() {
        int[] columnLengths = new int[this.columns];
        for (int i = 0; i < columnLengths.length; ++i) {
            columnLengths[i] = 1;
        }
        for (List<String> row : this.rows) {
            for (int i = 0; i < columnLengths.length - 1; ++i) {
                String element = row.get(i);
                columnLengths[i] = Math.max(columnLengths[i], element.length() + 1);
            }
        }
        String tableFormat = this.getTableFormat(columnLengths);
        StringBuilder tableBuilder = new StringBuilder();
        for (List<String> row : this.rows) {
            tableBuilder.append(String.format(tableFormat, row.toArray()));
        }
        return tableBuilder.toString();
    }

    private String getTableFormat(int[] columnLengths) {
        StringBuilder tableFormatBuilder = new StringBuilder();
        tableFormatBuilder.append(this.getStringOfLength(this.offset));
        for (int columnLength : columnLengths) {
            tableFormatBuilder.append("%-").append(columnLength).append("s");
        }
        tableFormatBuilder.append('\n');
        return tableFormatBuilder.toString();
    }

    private String getStringOfLength(int length) {
        Preconditions.checkArgument(length >= 0, "length is negative: %s", length);
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }
}

