/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.deadlocks;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class DeadlockDetection {
    private static final TimeInterval CHECK_TIME_INTERVAL = TimeInterval.minutes(1L);
    private final Logger logger;
    private final ErrorTriggerExecutor errorTriggerExecutor;
    private final Timer watchdog = new Timer(true);

    @Inject
    public DeadlockDetection(ErrorTriggerExecutor errorTriggerExecutor, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.errorTriggerExecutor = Preconditions.checkNotNull(errorTriggerExecutor);
    }

    public void start() {
        this.watchdog.scheduleAtFixedRate((TimerTask)new TestDeadlockTask(), 0L, CHECK_TIME_INTERVAL.toMilliseconds());
    }

    Optional<String> testForDeadlock() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] threadIds = bean.findDeadlockedThreads();
        if (threadIds != null) {
            ThreadInfo[] infos = bean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            StringBuilder stackTrace = new StringBuilder();
            for (ThreadInfo info : infos) {
                stackTrace.append(info).append('\n');
            }
            return Optional.of(stackTrace.toString());
        }
        return Optional.absent();
    }

    private class TestDeadlockTask
    extends TimerTask {
        private TestDeadlockTask() {
        }

        @Override
        public void run() {
            Optional<String> deadlockStack = DeadlockDetection.this.testForDeadlock();
            if (deadlockStack.isPresent()) {
                DeadlockDetection.this.logger.logf(Level.SEVERE, "Deadlock encountered. Stopping.\n %s", deadlockStack.get());
                DeadlockDetection.this.errorTriggerExecutor.executeErrorTrigger("Deadlock encountered. Stopping.\n" + deadlockStack.get());
                System.exit(5);
            }
        }
    }
}

