/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.dependencies;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutionException;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutor;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyCheck;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyRegistry;

@Singleton
public class LinuxSoftwareDependencyCheck
implements SoftwareDependencyRegistry,
SoftwareDependencyCheck {
    private final Set<String> programs = Sets.newHashSet();
    private final Logger logger;

    @Inject
    public LinuxSoftwareDependencyCheck(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void requireProgram(String programName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(programName));
        Preconditions.checkArgument(!programName.contains(" "));
        this.programs.add(programName);
    }

    @Override
    public void requirePrograms(Collection<String> programs) {
        for (String program : programs) {
            this.requireProgram(program);
        }
    }

    @Override
    public Collection<String> determineMissingPrograms() {
        if (!this.isProgramAvailable("which")) {
            return Lists.newArrayList("which");
        }
        ArrayList<String> missingProgram = Lists.newArrayList();
        for (String programName : this.programs) {
            if (this.isProgramAvailable(programName)) continue;
            missingProgram.add(programName);
        }
        return missingProgram;
    }

    private boolean isProgramAvailable(String program) {
        ProcessExecutor processExecutor = new ProcessExecutor(this.logger);
        try {
            processExecutor.executeProcess("which " + program);
            return true;
        }
        catch (ProcessExecutionException e) {
            return false;
        }
    }
}

