/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.dependencies;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyCheck;

public class NothingAvailableSoftwareDependencyCheck
implements SoftwareDependencyCheck {
    private final Set<String> requiredPrograms = Sets.newHashSet();

    @Override
    public void requireProgram(String programName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(programName));
        this.requiredPrograms.add(programName);
    }

    @Override
    public void requirePrograms(Collection<String> programs) {
        for (String program : programs) {
            this.requireProgram(program);
        }
    }

    @Override
    public Collection<String> determineMissingPrograms() {
        return this.requiredPrograms;
    }
}

