/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.disk_space;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.disk_space.NoFreeDiskSpaceDetection;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class DefaultNoFreeDiskSpaceDetection
implements NoFreeDiskSpaceDetection {
    private static final MemoryUnit MIN_FREE_SPACE = MemoryUnit.megabyte(10L);
    private final TimeInterval FREE_DISK_SPACE_CHECK_PERIODE = TimeInterval.minutes(1L);
    private final ScheduledExecutorService executor;
    private final NoFreeDiskSpaceDetectionRunnable task;

    @Inject
    public DefaultNoFreeDiskSpaceDetection(ApplicationService application, SystemInformationProvider systemInformationProvider, ErrorTriggerExecutor errorTriggerExecutor, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        this.task = new NoFreeDiskSpaceDetectionRunnable(application, systemInformationProvider, errorTriggerExecutor, logger);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("checkFreeDiskSpace-%d").setUncaughtExceptionHandler(uncaughtExceptionHandler);
        this.executor = Executors.newSingleThreadScheduledExecutor(tfb.build());
    }

    @Override
    public void start() {
        this.executor.scheduleAtFixedRate(this.task, 0L, this.FREE_DISK_SPACE_CHECK_PERIODE.toSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    private static final class NoFreeDiskSpaceDetectionRunnable
    implements Runnable {
        private final ApplicationService application;
        private final SystemInformationProvider systemInformationProvider;
        private final ErrorTriggerExecutor errorTriggerExecutor;
        private final Logger logger;

        public NoFreeDiskSpaceDetectionRunnable(ApplicationService application, SystemInformationProvider systemInformationProvider, ErrorTriggerExecutor errorTriggerExecutor, Logger logger) {
            this.application = Preconditions.checkNotNull(application);
            this.systemInformationProvider = Preconditions.checkNotNull(systemInformationProvider);
            this.errorTriggerExecutor = Preconditions.checkNotNull(errorTriggerExecutor);
            this.logger = Preconditions.checkNotNull(logger);
        }

        @Override
        public void run() {
            MemoryUnit freeSpaceWorkingDirectory;
            try {
                freeSpaceWorkingDirectory = this.systemInformationProvider.getFreeSpaceWorkingDir();
            }
            catch (SystemEnvironmentException e) {
                throw new RuntimeException(e);
            }
            if (!freeSpaceWorkingDirectory.isGreaterEqualThan(MIN_FREE_SPACE)) {
                String message = String.format("Only %s free space in working directory.", freeSpaceWorkingDirectory);
                this.logger.logf(Level.SEVERE, message, new Object[0]);
                this.errorTriggerExecutor.executeErrorTrigger(message);
                this.application.stop();
            }
        }
    }
}

