/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.error_trigger;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;

public class DefaultErrorTriggerExecutor
implements ErrorTriggerExecutor {
    private final Optional<String> errorTriggerCommand;
    private final Logger logger;

    @Inject
    public DefaultErrorTriggerExecutor(@Named(value="error-trigger-command") Optional<String> errorTriggerCommand, Logger logger) {
        this.errorTriggerCommand = Preconditions.checkNotNull(errorTriggerCommand);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void executeErrorTrigger(String errorMessage) {
        PrintStream stdOut;
        Process errorTrigger;
        if (!this.errorTriggerCommand.isPresent()) {
            return;
        }
        this.logger.logf(Level.INFO, "Executing error trigger %s.", this.errorTriggerCommand.get());
        try {
            errorTrigger = new ProcessBuilder(this.errorTriggerCommand.get()).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        }
        catch (IOException e) {
            this.logger.logf(Level.WARNING, "Io error during error trigger execution: %s", e.getMessage());
            return;
        }
        try {
            stdOut = new PrintStream(errorTrigger.getOutputStream(), false, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        stdOut.printf(errorMessage, new Object[0]);
        stdOut.close();
        try {
            int exitCode = errorTrigger.waitFor();
            if (exitCode != 0) {
                this.logger.logf(Level.WARNING, "Error trigger's exit code was: %i", exitCode);
            }
        }
        catch (InterruptedException e) {
            this.logger.logf(Level.WARNING, "Interrupted during error trigger execution: %s", e.getMessage());
        }
    }

    @Override
    public void executeErrorTrigger(Throwable t, String event) {
        StringBuilder errorMessage = new StringBuilder().append(event).append('\n').append(Throwables.getStackTraceAsString(t)).append("\n");
        this.executeErrorTrigger(errorMessage.toString());
    }

    @Override
    public void executeErrorTriggerForUncaughtException(Thread t, Throwable e) {
        StringBuilder errorMessage = new StringBuilder().append("Uncaught exception in thread ").append(t.getName()).append("\n").append(Throwables.getStackTraceAsString(e)).append("\n");
        this.executeErrorTrigger(errorMessage.toString());
    }
}

