/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutionException;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutor;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyRegistry;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;

public class EnergyProvider {
    private static final String READ_INTEL_CPIU_PROGRAM = "/usr/bin/read-intel-cpu";
    private Logger logger;

    @Inject
    public EnergyProvider(SoftwareDependencyRegistry dependencies, Logger logger) {
        dependencies.requireProgram(READ_INTEL_CPIU_PROGRAM);
        this.logger = Preconditions.checkNotNull(logger);
    }

    public long getEnergyValueInMilliJoule() throws SystemEnvironmentException {
        ProcessExecutor pe = new ProcessExecutor(this.logger);
        try {
            String milliJouleString = pe.executeProcess("/usr/bin/read-intel-cpu energy-cpu");
            try {
                return Long.parseLong(milliJouleString);
            }
            catch (NumberFormatException e) {
                throw new SystemEnvironmentException("Unknown output format of read-intel-cpu.");
            }
        }
        catch (ProcessExecutionException e) {
            throw new SystemEnvironmentException("Unable to determine energy usage.");
        }
    }
}

