/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutor;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class SSHCommandBuilder {
    private final String host;
    private final String remoteCommand;
    private boolean batchMode = true;
    private Optional<Integer> remotePort = Optional.absent();
    private Optional<Integer> localTargetPort = Optional.absent();
    private Optional<TimeInterval> keepAliveTime = Optional.absent();

    private SSHCommandBuilder(String host, String command) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(host));
        this.host = host;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(command));
        this.remoteCommand = command;
    }

    public static SSHCommandBuilder sshTo(String host, String command) {
        return new SSHCommandBuilder(host, command);
    }

    public SSHCommandBuilder setUpReverseTunnel(int remotePort, int localTargetPort, TimeInterval keepAliveTime) {
        Preconditions.checkArgument(remotePort >= 1024 && remotePort < 49151);
        this.remotePort = Optional.of(remotePort);
        Preconditions.checkArgument(localTargetPort >= 1 && remotePort < 49151);
        this.localTargetPort = Optional.of(localTargetPort);
        this.keepAliveTime = Optional.of(keepAliveTime);
        return this;
    }

    public String build() {
        String escapedRemoteCommand;
        StringBuilder sshCommand = new StringBuilder("ssh ");
        if (this.batchMode) {
            sshCommand.append("-oBatchMode=yes ");
        }
        if (this.remotePort.isPresent()) {
            sshCommand.append("-oExitOnForwardFailure=yes ");
            sshCommand.append("-f ");
            sshCommand.append("-R ").append(this.remotePort.get()).append(":localhost:").append(this.localTargetPort.get()).append(' ');
        }
        sshCommand.append(this.host).append(' ');
        sshCommand.append('\"');
        if (this.remotePort.isPresent()) {
            String commandDelimiter = this.containsCommandDelimiter(this.remoteCommand) ? "" : " ; ";
            escapedRemoteCommand = ProcessExecutor.escapeCommand(this.remoteCommand + commandDelimiter + " sleep " + this.keepAliveTime.get().toSeconds());
        } else {
            escapedRemoteCommand = ProcessExecutor.escapeCommand(this.remoteCommand);
        }
        sshCommand.append(escapedRemoteCommand);
        sshCommand.append('\"');
        return sshCommand.toString();
    }

    private boolean containsCommandDelimiter(String bashCommand) {
        String trimmedCommand = bashCommand.trim();
        if (trimmedCommand.isEmpty()) {
            return true;
        }
        switch (trimmedCommand.charAt(trimmedCommand.length() - 1)) {
            case '&': 
            case ';': {
                return true;
            }
        }
        return false;
    }
}

