/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system;

import com.google.common.collect.ImmutableSet;
import java.net.UnknownHostException;
import java.util.Map;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.units.frequency.Frequency;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public interface SystemInformationProvider {
    public String getUsername();

    public HostInformation getHostInformation() throws SystemEnvironmentException;

    public MemoryUnit getFreeSpaceWorkingDir() throws SystemEnvironmentException;

    public MemoryUnit getFreeSpaceTemp() throws SystemEnvironmentException;

    public Frequency getProcessorFrequency() throws SystemEnvironmentException;

    public String getHostname() throws UnknownHostException;

    public ImmutableSet<Processor> getProcessors() throws SystemEnvironmentException;

    public Map<Processor, Integer> getProcessorNumaNodeMapping() throws SystemEnvironmentException;

    public MemoryUnit getTotalMemory() throws SystemEnvironmentException;

    public Map<Integer, MemoryUnit> getTotalNumaMemory() throws SystemEnvironmentException;

    public MemoryUnit getAvailableMemory() throws SystemEnvironmentException;

    public Map<Integer, MemoryUnit> getAvailableNumaMemory() throws SystemEnvironmentException;

    public LoadData getLoad() throws SystemEnvironmentException;

    public String getCPUModel() throws SystemEnvironmentException;

    public boolean isCgroupsAvailable() throws SystemEnvironmentException;

    public ImmutableSet<Processor> getUnusableProcessors() throws SystemEnvironmentException;

    public MemoryUnit getUsableMemory() throws SystemEnvironmentException;
}

