/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.cache;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sosy_lab.verifiercloud.global.util.system.cache.InstanceProvider;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class OneValueCache<T, E extends Exception> {
    private final long cacheValidityMillis;
    private final InstanceProvider<T, E> provider;
    private volatile long cacheTimeInvalidMillis = 0L;
    @Nullable
    private volatile T cachedValue = null;

    public OneValueCache(TimeInterval cacheValidity, InstanceProvider<T, E> provider) {
        this.cacheValidityMillis = cacheValidity.toMilliseconds();
        this.provider = Preconditions.checkNotNull(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        OneValueCache oneValueCache = this;
        synchronized (oneValueCache) {
            this.cachedValue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws E {
        OneValueCache oneValueCache = this;
        synchronized (oneValueCache) {
            long currentTimeMillis = System.currentTimeMillis();
            if (this.cachedValue == null || this.cacheTimeInvalidMillis < currentTimeMillis) {
                this.cachedValue = this.provider.getInstance();
                this.cacheTimeInvalidMillis = currentTimeMillis + this.cacheValidityMillis;
                this.valueChanged(this.cachedValue);
            }
            return this.cachedValue;
        }
    }

    protected void valueChanged(T newValue) {
    }
}

