/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.guice;

import com.google.common.base.StandardSystemProperty;
import com.google.inject.AbstractModule;
import org.sosy_lab.verifiercloud.global.util.dependencies.LinuxSoftwareDependencyCheck;
import org.sosy_lab.verifiercloud.global.util.dependencies.NothingAvailableSoftwareDependencyCheck;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyCheck;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyRegistry;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.linux.LinuxSystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.unimplemented.UnimplementedSystemInformationProvider;

public class OperatingSystemSpecificBindingsModule
extends AbstractModule {
    @Override
    protected void configure() {
        StandardSystemProperty osProperty = StandardSystemProperty.OS_NAME;
        String osName = osProperty.value();
        this.bind(SoftwareDependencyRegistry.class).to(SoftwareDependencyCheck.class);
        if (osName.startsWith("Linux")) {
            this.bind(SystemInformationProvider.class).to(LinuxSystemInformationProvider.class);
            this.bind(SoftwareDependencyCheck.class).to(LinuxSoftwareDependencyCheck.class);
        } else {
            this.bind(SystemInformationProvider.class).to(UnimplementedSystemInformationProvider.class);
            this.bind(SoftwareDependencyCheck.class).to(NothingAvailableSoftwareDependencyCheck.class);
        }
    }
}

