/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.net.InternetDomainName;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationUtils;
import org.sosy_lab.verifiercloud.global.util.system.linux.cgroups.CgroupsReader;
import org.sosy_lab.verifiercloud.global.util.system.linux.load.LoadDataReader;
import org.sosy_lab.verifiercloud.global.util.system.linux.memory.MemoryReader;
import org.sosy_lab.verifiercloud.global.util.system.linux.processors.ProcessorReader;
import org.sosy_lab.verifiercloud.transportable.info.processors.NumaProcessorParser;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.processors.ProcessorParser;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.DefaultHostInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.units.frequency.Frequency;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class LinuxSystemInformationProvider
implements SystemInformationProvider {
    private static final Path TMP_PATH = Paths.get("/tmp", new String[0]);
    private final CgroupsReader cgroupsReader;
    private final MemoryReader memoryReader;
    private final LoadDataReader loadDataReader;
    private final ProcessorReader processorReader;
    private volatile Optional<HostInformation> hostInformation = Optional.absent();

    @Inject
    public LinuxSystemInformationProvider(Logger logger) {
        this.cgroupsReader = new CgroupsReader(logger);
        this.memoryReader = new MemoryReader();
        this.loadDataReader = new LoadDataReader();
        this.processorReader = new ProcessorReader();
    }

    @Override
    public String getUsername() {
        return StandardSystemProperty.USER_NAME.value();
    }

    @Override
    public HostInformation getHostInformation() throws SystemEnvironmentException {
        if (!this.hostInformation.isPresent()) {
            try {
                DefaultHostInformation hostInfo = new DefaultHostInformation(this.getHostname(), this.getUsername(), this.getCPUModel(), this.getProcessors(), this.getProcessorNumaNodeMapping(), this.getProcessorFrequency(), this.getTotalMemory(), this.getTotalNumaMemory(), this.isCgroupsAvailable());
                this.hostInformation = Optional.of(hostInfo);
            }
            catch (UnknownHostException e) {
                throw new SystemEnvironmentException(e);
            }
        }
        return this.hostInformation.get();
    }

    @Override
    public Frequency getProcessorFrequency() throws SystemEnvironmentException {
        return this.processorReader.getMaxFrequency();
    }

    @Override
    public String getHostname() throws UnknownHostException {
        String hostname = InetAddress.getLocalHost().getHostName();
        if (hostname.equals("localhost")) {
            throw new UnknownHostException("Host name is invalid: localhost");
        }
        return LinuxSystemInformationProvider.shortenHostname(hostname);
    }

    @VisibleForTesting
    static String shortenHostname(String hostname) {
        if (InternetDomainName.isValid(hostname)) {
            return (String)InternetDomainName.from(hostname).parts().get(0);
        }
        return hostname;
    }

    @Override
    public ImmutableSet<Processor> getProcessors() throws SystemEnvironmentException {
        if (this.hostInformation.isPresent()) {
            return this.hostInformation.get().getProcessors();
        }
        return ImmutableSet.copyOf(ProcessorParser.parseProcessorInformation());
    }

    @Override
    public Map<Processor, Integer> getProcessorNumaNodeMapping() throws SystemEnvironmentException {
        if (this.hostInformation.isPresent()) {
            return this.hostInformation.get().getProcessorNumaNodeMapping();
        }
        return ImmutableMap.copyOf(NumaProcessorParser.parseProcessorNumaInfo());
    }

    @Override
    public MemoryUnit getTotalMemory() throws SystemEnvironmentException {
        if (this.hostInformation.isPresent()) {
            return this.hostInformation.get().getTotalMemory();
        }
        return this.memoryReader.readTotalMemory();
    }

    @Override
    public Map<Integer, MemoryUnit> getTotalNumaMemory() throws SystemEnvironmentException {
        if (this.hostInformation.isPresent()) {
            return this.hostInformation.get().getTotalNumaMemory();
        }
        return this.memoryReader.readTotalNumaMemory();
    }

    @Override
    public String getCPUModel() throws SystemEnvironmentException {
        if (this.hostInformation.isPresent()) {
            return this.hostInformation.get().getCPUName();
        }
        return this.processorReader.getCPUModel();
    }

    @Override
    public boolean isCgroupsAvailable() throws SystemEnvironmentException {
        if (this.hostInformation.isPresent()) {
            return this.hostInformation.get().isCgroupsAvailable();
        }
        return this.cgroupsReader.isCgroupsAvailable();
    }

    @Override
    public LoadData getLoad() throws SystemEnvironmentException {
        return this.loadDataReader.readLoad();
    }

    @Override
    public MemoryUnit getAvailableMemory() throws SystemEnvironmentException {
        return this.memoryReader.readAvailableMemory();
    }

    @Override
    public Map<Integer, MemoryUnit> getAvailableNumaMemory() throws SystemEnvironmentException {
        return this.memoryReader.readAvailableNumaMemory();
    }

    @Override
    public ImmutableSet<Processor> getUnusableProcessors() throws SystemEnvironmentException {
        Optional<String> availableProcessors = this.cgroupsReader.getCgroupProcessorLimitations();
        if (!availableProcessors.isPresent()) {
            return ImmutableSet.of();
        }
        String actuallyAvailableProcessors = availableProcessors.get();
        ImmutableSet<Processor> allProcessors = this.getProcessors();
        return LinuxSystemInformationProvider.calculateUnusableProcessors(actuallyAvailableProcessors, allProcessors);
    }

    @VisibleForTesting
    static ImmutableSet<Processor> calculateUnusableProcessors(String availableProcessors, ImmutableSet<Processor> allProcessors) {
        final HashSet<Integer> usableProcessors = Sets.newHashSet();
        for (String interval : Splitter.on(',').split(availableProcessors)) {
            if (interval.contains("-")) {
                String[] intervalPoints = interval.split("-");
                int intervalStart = Integer.parseInt(intervalPoints[0]);
                int intervalEnd = Integer.parseInt(intervalPoints[1]);
                for (int i = intervalStart; i <= intervalEnd; ++i) {
                    usableProcessors.add(i);
                }
                continue;
            }
            usableProcessors.add(Integer.parseInt(interval));
        }
        return FluentIterable.from(allProcessors).filter(new Predicate<Processor>(){

            @Override
            public boolean apply(@Nonnull Processor input) {
                Preconditions.checkNotNull(input);
                return !usableProcessors.contains(input.getProcessorId());
            }
        }).toSet();
    }

    @Override
    public MemoryUnit getUsableMemory() throws SystemEnvironmentException {
        Optional<MemoryUnit> cgroupMemoryLimit = this.cgroupsReader.getCgroupMemoryLimit();
        MemoryUnit totalMemory = this.getTotalMemory();
        if (cgroupMemoryLimit.isPresent()) {
            return MemoryUnit.min(cgroupMemoryLimit.get(), totalMemory);
        }
        return totalMemory;
    }

    @Override
    public MemoryUnit getFreeSpaceWorkingDir() throws SystemEnvironmentException {
        Path workingDir = SystemInformationUtils.getWorkingDir();
        try {
            FileStore workingDirFileStore = Files.getFileStore(workingDir);
            return this.getFreeSpace(workingDirFileStore);
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    @Override
    public MemoryUnit getFreeSpaceTemp() throws SystemEnvironmentException {
        try {
            FileStore workingDirFileStore = Files.getFileStore(TMP_PATH);
            return this.getFreeSpace(workingDirFileStore);
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    private MemoryUnit getFreeSpace(FileStore fileStore) throws IOException {
        long unallocatedSpaceBytes = fileStore.getUnallocatedSpace();
        return MemoryUnit.bytes(unallocatedSpaceBytes);
    }
}

