/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyRegistry;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.UnexpectedFileFormatException;
import org.sosy_lab.verifiercloud.global.util.system.UserInformationProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.InstanceProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.OneValueCache;
import org.sosy_lab.verifiercloud.global.util.system.linux.processes.GetentUidToUsernameCallable;
import org.sosy_lab.verifiercloud.global.util.system.linux.processes.ProcessInformation;
import org.sosy_lab.verifiercloud.global.util.system.linux.processes.UsersPrograms;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Singleton
public class LinuxUserInformationProvider
implements UserInformationProvider {
    private final Logger logger;
    private static final Path PROC_PATH = Paths.get("/proc", new String[0]);
    private static final ImmutableSet<String> REQUIRED_PROGRAMS = ImmutableSet.of("getent");
    private static final Pattern NUMERIC_PATH_PATTERN = Pattern.compile("[/]?[0-9]+[/]?");
    private final LoadingCache<Integer, String> uidCache;
    private final ImmutableSet<String> ignoredUsers;
    private final ImmutableSet<String> ignoredPrograms;
    private final int minHumanUid;
    private final OneValueCache<UsersPrograms, SystemEnvironmentException> resultCache;

    @Inject
    public LinuxUserInformationProvider(SystemInformationProvider systemInfoProvider, SoftwareDependencyRegistry dependencyCheck, Logger logger, @Named(value="ignored-users") ImmutableSet<String> ignoredUsers, @Named(value="ignored-programs") ImmutableSet<String> ignoredPrograms, @Named(value="min-human-uid") int minHumanUid) {
        this.logger = logger;
        this.ignoredUsers = ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll(ignoredUsers)).add(systemInfoProvider.getUsername())).build();
        this.ignoredPrograms = ignoredPrograms;
        this.minHumanUid = minHumanUid;
        dependencyCheck.requirePrograms(REQUIRED_PROGRAMS);
        this.uidCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build(new GetentUidToUsernameCallable(logger));
        this.resultCache = new OneValueCache<UsersPrograms, SystemEnvironmentException>(TimeInterval.seconds(30L), new InstanceProvider<UsersPrograms, SystemEnvironmentException>(){

            @Override
            public UsersPrograms getInstance() throws SystemEnvironmentException {
                return LinuxUserInformationProvider.this.currentProcesses();
            }
        });
    }

    LinuxUserInformationProvider(Logger logger, CacheLoader<? super Integer, String> cacheLoader, ImmutableSet<String> ignoredUsers, ImmutableSet<String> ignoredPrograms, int minHumanUid) {
        this.logger = logger;
        this.ignoredUsers = ignoredUsers;
        this.ignoredPrograms = ignoredPrograms;
        this.minHumanUid = minHumanUid;
        this.uidCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build(cacheLoader);
        this.resultCache = new OneValueCache<UsersPrograms, SystemEnvironmentException>(TimeInterval.milliseconds(1L), new InstanceProvider<UsersPrograms, SystemEnvironmentException>(){

            @Override
            public UsersPrograms getInstance() throws SystemEnvironmentException {
                return LinuxUserInformationProvider.this.currentProcesses();
            }
        });
    }

    private static boolean isNumeric(String str) {
        return NUMERIC_PATH_PATTERN.matcher(str).matches();
    }

    @VisibleForTesting
    UsersPrograms getActiveUsers(DirectoryStream<Path> directoryStream) {
        ImmutableSet.Builder activeUsers = new ImmutableSet.Builder();
        ImmutableSet.Builder activePrograms = new ImmutableSet.Builder();
        for (Path path : directoryStream) {
            String programName;
            ProcessInformation procInfo;
            if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) || !LinuxUserInformationProvider.isNumeric(path.getFileName().toString())) continue;
            try {
                procInfo = ProcessInformation.parseProcStatusFile(Files.readAllLines(path.resolve("status"), Charset.defaultCharset()));
            }
            catch (IOException | UnexpectedFileFormatException e) {
                this.logger.logf(Level.FINE, "Cannot get status of process in %s.", path);
                continue;
            }
            Integer uid = procInfo.getUserId();
            if (uid < this.minHumanUid || this.ignoredPrograms.contains(programName = procInfo.getProgramName())) continue;
            try {
                String username = this.uidCache.get(uid);
                if (this.ignoredUsers.contains(username)) continue;
                activeUsers.add(username);
                activePrograms.add(programName);
            }
            catch (ExecutionException e) {
                this.logger.logf(Level.WARNING, "Cannot get username for uid %d.", uid);
                activeUsers.add(uid.toString());
            }
        }
        return new UsersPrograms((ImmutableSet<String>)activeUsers.build(), (ImmutableSet<String>)activePrograms.build());
    }

    @Override
    public ImmutableSet<String> getActiveUsers() throws SystemEnvironmentException {
        return this.resultCache.get().getUsers();
    }

    @Override
    public ImmutableSet<String> getActivePrograms() throws SystemEnvironmentException {
        return this.resultCache.get().getPrograms();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UsersPrograms currentProcesses() throws SystemEnvironmentException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(PROC_PATH);){
            UsersPrograms usersPrograms = this.getActiveUsers(directoryStream);
            return usersPrograms;
        }
        catch (IOException e) {
            throw new SystemEnvironmentException("Could not list process status files in " + PROC_PATH + ": " + e.getMessage());
        }
    }

    @Override
    public boolean isOtherUserLoggedIn() throws SystemEnvironmentException {
        return !this.getActiveUsers().isEmpty();
    }
}

