/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux.cgroups;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLongs;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.UnexpectedFileFormatException;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class CgroupsReader {
    private static final String NO_BYTE_CODE = "-B";
    private static final String CGROUPS_CHECK_DIR = "_cgroupsCheck_";
    private static final String CGROUPS_CHECKER = "isCgroupsAvailable.py";
    private static final List<String> CGROUPS_CHECKER_FILES = ImmutableList.of("isCgroupsAvailable.py", "benchmark/__init__.py", "benchmark/cgroups.py", "benchmark/util.py");
    private static final String CGROUPS_CPUSET = "cpuset";
    private static final String CGROUPS_MEMORY = "memory";
    private static final Pattern CGROUP_MOUNTPOINT = Pattern.compile("^\\S+ (\\S+) cgroup (\\S+) .*");
    private final Logger logger;

    public CgroupsReader(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    public Optional<String> getCgroupProcessorLimitations() throws SystemEnvironmentException {
        List<String> allLines;
        Optional<Path> activeProcessorsFile = this.getCgroupPath(CGROUPS_CPUSET, "cpuset.cpus");
        if (!activeProcessorsFile.isPresent()) {
            return Optional.absent();
        }
        try {
            allLines = Files.readAllLines(activeProcessorsFile.get(), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
        if (allLines.size() != 1) {
            throw new UnexpectedFileFormatException(activeProcessorsFile.get() + " has " + allLines.size() + " lines instead of one.");
        }
        return Optional.of(allLines.get(0));
    }

    public Optional<MemoryUnit> getCgroupMemoryLimit() throws SystemEnvironmentException {
        List<String> allLines;
        Optional<Path> memoryLimitFile = this.getCgroupPath(CGROUPS_MEMORY, "memory.limit_in_bytes");
        if (!memoryLimitFile.isPresent()) {
            return Optional.absent();
        }
        try {
            allLines = Files.readAllLines(memoryLimitFile.get(), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
        if (allLines.size() != 1) {
            throw new UnexpectedFileFormatException(memoryLimitFile.get() + " has " + allLines.size() + " lines instead of one.");
        }
        String cgroupLimitString = allLines.get(0);
        try {
            long unsignedBytes = UnsignedLongs.decode(cgroupLimitString);
            if (unsignedBytes < 0L) {
                this.logger.logf(Level.FINEST, "Cgroup memory limit is too large to be represented as long: %s. Interpreting as no cgroup memory limit.", cgroupLimitString);
                return Optional.absent();
            }
            return Optional.of(MemoryUnit.bytes(unsignedBytes));
        }
        catch (NumberFormatException e) {
            throw new UnexpectedFileFormatException(cgroupLimitString + " is not a valid byte limit.");
        }
    }

    private Optional<Path> getCgroupPath(String cgroupName, String informationFileName) throws SystemEnvironmentException {
        Path activeProcessorsFile;
        String ownCgroupPath;
        Path cgroupMountpoint;
        Level logLevel = Level.ALL;
        try {
            Optional<Path> mountpoint = this.findCgroupMountpoint(cgroupName);
            if (!mountpoint.isPresent()) {
                this.logger.logf(logLevel, "No cgroup mountpoint for subsystem %s found", cgroupName);
                return Optional.absent();
            }
            cgroupMountpoint = mountpoint.get();
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
        try {
            Optional<String> cgroupPath = this.findOwnCgroup(cgroupName);
            if (!cgroupPath.isPresent()) {
                this.logger.logf(logLevel, "No path for subsystem %s found", cgroupName);
                return Optional.absent();
            }
            ownCgroupPath = cgroupPath.get();
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
        if (ownCgroupPath.charAt(0) == '/') {
            ownCgroupPath = ownCgroupPath.substring(1);
        }
        if (!Files.exists(activeProcessorsFile = cgroupMountpoint.resolve(ownCgroupPath).resolve(informationFileName), new LinkOption[0])) {
            this.logger.logf(logLevel, "File %s with processor restrictions does not exist.", activeProcessorsFile);
            return Optional.absent();
        }
        return Optional.of(activeProcessorsFile);
    }

    private Optional<Path> findCgroupMountpoint(String subsystem) throws IOException {
        for (String mount : Files.readAllLines(Paths.get("/proc/mounts", new String[0]), Charset.defaultCharset())) {
            Matcher matcher = CGROUP_MOUNTPOINT.matcher(mount);
            if (!matcher.matches()) continue;
            String options = matcher.group(2);
            if (!FluentIterable.from(Splitter.on(',').split(options)).contains(subsystem)) continue;
            String path = matcher.group(1);
            return Optional.of(Paths.get(path, new String[0]));
        }
        return Optional.absent();
    }

    private Optional<String> findOwnCgroup(String subsystem) throws IOException {
        for (String cgroup : Files.readAllLines(Paths.get("/proc/self/cgroup", new String[0]), Charset.defaultCharset())) {
            String[] ownCgroup = cgroup.trim().split(":");
            if (!FluentIterable.from(Splitter.on(',').split(ownCgroup[1])).contains(subsystem)) continue;
            return Optional.of(ownCgroup[2]);
        }
        this.logger.logf(Level.WARNING, "Could not identify my cgroup for subsystem %s although it should be there", subsystem);
        return Optional.absent();
    }

    public boolean isCgroupsAvailable() throws SystemEnvironmentException {
        try {
            String resultString = this.checkCgroups();
            if (resultString.isEmpty()) {
                this.logger.logf(Level.FINER, "Cgroups check gave no result", new Object[0]);
            } else {
                this.logger.logf(Level.FINER, "Result of Cgroups check: %s", resultString);
            }
            return Boolean.parseBoolean(resultString);
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private String checkCgroups() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

