/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux.load;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.UnexpectedFileFormatException;
import org.sosy_lab.verifiercloud.global.util.system.cache.InstanceProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.OneValueCache;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public final class LoadDataReader {
    private static final Path LOADAVG_PATH = Paths.get("/proc/loadavg", new String[0]);
    private static final Pattern LOADAVG_FILE_PATTERN = Pattern.compile("^(.*) (.*) (.*) .* .*$");
    private final OneValueCache<LoadData, SystemEnvironmentException> valueCache = new OneValueCache<LoadData, SystemEnvironmentException>(TimeInterval.seconds(4L), new LoadProvider());

    public LoadData readLoad() throws SystemEnvironmentException {
        return this.valueCache.get();
    }

    @VisibleForTesting
    static LoadData parseLoadavg(String loadavg) throws SystemEnvironmentException {
        Matcher matcher = LOADAVG_FILE_PATTERN.matcher(loadavg);
        if (matcher.matches()) {
            String load1 = matcher.group(1);
            String load5 = matcher.group(2);
            String load15 = matcher.group(3);
            return new LoadData(LoadDataReader.parseFloat(load1), LoadDataReader.parseFloat(load5), LoadDataReader.parseFloat(load15));
        }
        throw new UnexpectedFileFormatException("File format of " + LOADAVG_PATH + " is unexpected: '" + loadavg + "'");
    }

    private static float parseFloat(String str) throws UnexpectedFileFormatException {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            throw new UnexpectedFileFormatException("Expected floating point number instead of " + str);
        }
    }

    private static final class LoadProvider
    implements InstanceProvider<LoadData, SystemEnvironmentException> {
        private LoadProvider() {
        }

        @Override
        public LoadData getInstance() throws SystemEnvironmentException {
            try {
                String loadData = Files.readAllLines(LOADAVG_PATH, Charset.defaultCharset()).get(0);
                return LoadDataReader.parseLoadavg(loadData);
            }
            catch (IOException e) {
                throw new SystemEnvironmentException(e);
            }
        }
    }
}

