/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.UnexpectedFileFormatException;
import org.sosy_lab.verifiercloud.global.util.system.cache.InstanceProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.OneValueCache;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public final class MemoryReader {
    private static final Path MEMINFO_PATH = Paths.get("/proc/meminfo", new String[0]);
    private static final Path NODE_PATH = Paths.get("/sys/devices/system/node", new String[0]);
    private static final Path NODE_NUMBER_PATH = NODE_PATH.resolve("has_memory");
    private static final Path NODE_NUMBER_PATH_2 = NODE_PATH.resolve("has_normal_memory");
    private static final Splitter NODE_NUMBER_SPLITTER = Splitter.on('-');
    private volatile MemoryUnit totalMemory = null;
    private volatile ImmutableMap<Integer, MemoryUnit> totalMemoryNodewise = null;
    private final OneValueCache<MemoryUnit, SystemEnvironmentException> availableMemoryCache = new OneValueCache<MemoryUnit, SystemEnvironmentException>(TimeInterval.minutes(1L), new AvailableMemoryProvider());
    private final OneValueCache<Map<Integer, MemoryUnit>, SystemEnvironmentException> availableNumaMemoryCache = new OneValueCache<Map<Integer, MemoryUnit>, SystemEnvironmentException>(TimeInterval.minutes(1L), new AvailableNumaMemoryProvider());
    private static final Pattern MEM_FREE_PATTERN = Pattern.compile("MemFree:\\s*(\\d+)\\s*kB");
    private static final Pattern MEM_BUFFERS_PATTERN = Pattern.compile("Buffers:\\s*(\\d+)\\s*kB");
    private static final Pattern MEM_CACHED_PATTERN = Pattern.compile("Cached:\\s*(\\d+)\\s*kB");
    private static final Pattern MEM_TOTAL_PATTERN = Pattern.compile("MemTotal:\\s*(\\d+)\\s*kB");
    private static final Pattern NODE_MEM_FREE_PATTERN = Pattern.compile("Node [0-9]+ MemFree:\\s*(\\d+)\\s*kB");
    private static final Pattern NODE_MEM_INACTIVE_PATTERN = Pattern.compile("Node [0-9]+ Inactive:\\s*(\\d+)\\s*kB");
    private static final Pattern NODE_MEM_TOTAL_PATTERN = Pattern.compile("Node [0-9]+ MemTotal:\\s*(\\d+)\\s*kB");

    public MemoryUnit readTotalMemory() throws SystemEnvironmentException {
        if (this.totalMemory != null) {
            return this.totalMemory;
        }
        try {
            List<String> meminfoLines = Files.readAllLines(MEMINFO_PATH, Charset.defaultCharset());
            this.totalMemory = MemoryReader.getTotalMemory(meminfoLines);
            return this.totalMemory;
        }
        catch (IOException | UnexpectedFileFormatException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    public ImmutableMap<Integer, MemoryUnit> readTotalNumaMemory() throws SystemEnvironmentException {
        if (this.totalMemoryNodewise != null) {
            return this.totalMemoryNodewise;
        }
        try {
            Map<Integer, List<String>> meminfoLines = MemoryReader.getNumaMemInfoLines();
            if (meminfoLines.isEmpty()) {
                return ImmutableMap.of(0, this.readTotalMemory());
            }
            return MemoryReader.getTotalNumaMemory(meminfoLines);
        }
        catch (IOException | UnexpectedFileFormatException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    @VisibleForTesting
    static MemoryUnit getTotalMemory(List<String> meminfoLines) throws UnexpectedFileFormatException {
        Optional<MemoryUnit> memTotal = MemoryReader.getLineMatchedByPattern(MEM_TOTAL_PATTERN, meminfoLines);
        if (memTotal.isPresent()) {
            return memTotal.get();
        }
        throw new UnexpectedFileFormatException("Total memory could not be determined: MemTotal not found in '" + MEMINFO_PATH + "'");
    }

    @VisibleForTesting
    static ImmutableMap<Integer, MemoryUnit> getTotalNumaMemory(Map<Integer, List<String>> meminfoLines) throws UnexpectedFileFormatException {
        ImmutableMap.Builder<Integer, MemoryUnit> totalMemory = ImmutableMap.builder();
        for (Map.Entry<Integer, List<String>> nodeMemInfoLines : meminfoLines.entrySet()) {
            Optional<MemoryUnit> memTotal = MemoryReader.getLineMatchedByPattern(NODE_MEM_TOTAL_PATTERN, nodeMemInfoLines.getValue());
            if (memTotal.isPresent()) {
                totalMemory.put(nodeMemInfoLines.getKey(), memTotal.get());
                continue;
            }
            throw new UnexpectedFileFormatException("Total memory could not be determined: MemTotal not found in '" + nodeMemInfoLines + "'");
        }
        return totalMemory.build();
    }

    public MemoryUnit readAvailableMemory() throws SystemEnvironmentException {
        return this.availableMemoryCache.get();
    }

    public Map<Integer, MemoryUnit> readAvailableNumaMemory() throws SystemEnvironmentException {
        return this.availableNumaMemoryCache.get();
    }

    @VisibleForTesting
    static MemoryUnit getAvailableMemory(List<String> meminfoLines) {
        return MemoryUnit.sum(MemoryReader.getLineMatchedByPattern(MEM_FREE_PATTERN, meminfoLines).or(MemoryUnit.zero()), MemoryReader.getLineMatchedByPattern(MEM_BUFFERS_PATTERN, meminfoLines).or(MemoryUnit.zero()), MemoryReader.getLineMatchedByPattern(MEM_CACHED_PATTERN, meminfoLines).or(MemoryUnit.zero()));
    }

    @VisibleForTesting
    static Map<Integer, MemoryUnit> getAvailableNumaMemory(Map<Integer, List<String>> memInfoLines) {
        ImmutableMap.Builder<Integer, MemoryUnit> freeMemory = ImmutableMap.builder();
        for (Map.Entry<Integer, List<String>> nodeMemInfoLines : memInfoLines.entrySet()) {
            freeMemory.put(nodeMemInfoLines.getKey(), MemoryUnit.sum(MemoryReader.getLineMatchedByPattern(NODE_MEM_FREE_PATTERN, nodeMemInfoLines.getValue()).or(MemoryUnit.zero()), MemoryReader.getLineMatchedByPattern(NODE_MEM_INACTIVE_PATTERN, nodeMemInfoLines.getValue()).or(MemoryUnit.zero())));
        }
        return freeMemory.build();
    }

    private static Map<Integer, List<String>> getNumaMemInfoLines() throws IOException {
        int numberOfNodes;
        if (!Files.isReadable(NODE_NUMBER_PATH) && !Files.isReadable(NODE_NUMBER_PATH_2)) {
            return ImmutableMap.of();
        }
        List<String> memoryNodesLines = Files.isReadable(NODE_NUMBER_PATH) ? Files.readAllLines(NODE_NUMBER_PATH, Charsets.UTF_8) : Files.readAllLines(NODE_NUMBER_PATH_2, Charsets.UTF_8);
        assert (!memoryNodesLines.isEmpty()) : "memory node lines: " + memoryNodesLines;
        String memoryNodes = memoryNodesLines.get(0);
        List<String> nodeNumberTokens = NODE_NUMBER_SPLITTER.splitToList(memoryNodes);
        if (nodeNumberTokens.size() == 1 && nodeNumberTokens.get(0).equals("0")) {
            numberOfNodes = 1;
        } else if (nodeNumberTokens.size() == 2) {
            numberOfNodes = Integer.parseInt(nodeNumberTokens.get(1)) + 1;
        } else {
            throw new IOException("Cannot parse NUMA node information: " + memoryNodesLines);
        }
        ImmutableMap.Builder<Integer, List<String>> meminfoLines = ImmutableMap.builder();
        for (int node = 0; node < numberOfNodes; ++node) {
            Path meminfo = NODE_PATH.resolve("node" + node).resolve("meminfo");
            meminfoLines.put(node, Files.readAllLines(meminfo, Charset.defaultCharset()));
        }
        return meminfoLines.build();
    }

    private static Optional<MemoryUnit> getLineMatchedByPattern(Pattern pattern, List<String> lines) {
        for (String line : lines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return Optional.of(MemoryUnit.kibibyte(Long.parseLong(matcher.group(1))));
        }
        return Optional.absent();
    }

    private static class AvailableNumaMemoryProvider
    implements InstanceProvider<Map<Integer, MemoryUnit>, SystemEnvironmentException> {
        private AvailableNumaMemoryProvider() {
        }

        @Override
        public Map<Integer, MemoryUnit> getInstance() throws SystemEnvironmentException {
            try {
                Map meminfoLines = MemoryReader.getNumaMemInfoLines();
                if (meminfoLines.isEmpty()) {
                    MemoryUnit availableMemory = new MemoryReader().readAvailableMemory();
                    return ImmutableMap.of(0, availableMemory);
                }
                return MemoryReader.getAvailableNumaMemory(meminfoLines);
            }
            catch (IOException e) {
                throw new SystemEnvironmentException(e);
            }
        }
    }

    private static class AvailableMemoryProvider
    implements InstanceProvider<MemoryUnit, SystemEnvironmentException> {
        private AvailableMemoryProvider() {
        }

        @Override
        public MemoryUnit getInstance() throws SystemEnvironmentException {
            try {
                List<String> meminfoLines = Files.readAllLines(MEMINFO_PATH, Charset.defaultCharset());
                return MemoryReader.getAvailableMemory(meminfoLines);
            }
            catch (IOException e) {
                throw new SystemEnvironmentException(e);
            }
        }
    }
}

