/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux.processes;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutionException;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutor;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;

public final class GetentUidToUsernameCallable
extends CacheLoader<Integer, String> {
    private final Logger logger;

    public GetentUidToUsernameCallable(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    private String convertUidsToUsernames(int uid) throws IOException, SystemEnvironmentException {
        String getentOutput;
        try {
            getentOutput = new ProcessExecutor(this.logger).executeProcess("getent passwd " + uid);
        }
        catch (ProcessExecutionException e) {
            throw new SystemEnvironmentException("Getent returned no uid " + uid + " ");
        }
        Iterable<String> passwdLines = Splitter.on('\n').split(getentOutput);
        for (String line : passwdLines) {
            String[] lineParts = line.split(":");
            Integer currentLineUid = Integer.valueOf(lineParts[2]);
            if (!currentLineUid.equals(uid)) continue;
            return lineParts[0];
        }
        throw new SystemEnvironmentException("Unable to determine user to uid " + uid);
    }

    @Override
    public String load(Integer uid) throws Exception {
        String username = this.convertUidsToUsernames(uid);
        this.logger.logf(Level.FINER, "Resolved uid '%d' to username '%s'.", uid, username);
        return username;
    }
}

