/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux.processes;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.util.system.UnexpectedFileFormatException;

public class ProcessInformation {
    private static final Pattern PROGRAM_NAME_PATTERN = Pattern.compile("Name:\\s*(\\S+)\\s*$");
    private static final Pattern UID_PATTERN = Pattern.compile("Uid:\\s*(\\d+)\\s*.*");
    private final String programName;
    private final int userId;

    public static ProcessInformation parseProcStatusFile(List<String> statusLines) throws UnexpectedFileFormatException {
        String programName = null;
        Integer uid = null;
        for (String line : statusLines) {
            Matcher matcher = PROGRAM_NAME_PATTERN.matcher(line);
            if (matcher.matches()) {
                programName = matcher.group(1);
                continue;
            }
            matcher = UID_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            uid = Integer.valueOf(matcher.group(1));
            break;
        }
        if (programName == null || uid == null) {
            throw new UnexpectedFileFormatException("Program name or UID not found.");
        }
        return new ProcessInformation(programName, uid);
    }

    private ProcessInformation(String programName, int userId) {
        this.programName = Preconditions.checkNotNull(programName);
        this.userId = userId;
    }

    public String getProgramName() {
        return this.programName;
    }

    public int getUserId() {
        return this.userId;
    }
}

