/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.util.system.linux.processors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.UnexpectedFileFormatException;
import org.sosy_lab.verifiercloud.transportable.units.frequency.Frequency;

public class ProcessorReader {
    private static final Path CPUFREQ_PATH = Paths.get("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq", new String[0]);
    private static final Path CPUINFO_PATH = Paths.get("/proc/cpuinfo", new String[0]);

    public Frequency getMaxFrequency() throws SystemEnvironmentException {
        if (Files.isReadable(CPUFREQ_PATH)) {
            try {
                String maxFreqKHz = Files.readAllLines(CPUFREQ_PATH, Charset.defaultCharset()).get(0);
                return Frequency.inKHz(Long.parseLong(maxFreqKHz));
            }
            catch (IOException e) {
                throw new SystemEnvironmentException(e);
            }
        }
        try {
            List<String> cpuinfoLines = Files.readAllLines(CPUINFO_PATH, Charset.defaultCharset());
            return ProcessorReader.getProcessorFrequency(cpuinfoLines);
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    @VisibleForTesting
    static Frequency getProcessorFrequency(List<String> cpuinfoLines) throws UnexpectedFileFormatException {
        Pattern pattern = Pattern.compile("cpu MHz\\s*:\\s*([0-9.]+)");
        for (String line : cpuinfoLines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return Frequency.inMHz(Float.parseFloat(matcher.group(1)));
        }
        throw new UnexpectedFileFormatException("Missing frequency in cpuinfo.");
    }

    public String getCPUModel() throws SystemEnvironmentException {
        try {
            List<String> cpuinfoLines = Files.readAllLines(CPUINFO_PATH, Charset.defaultCharset());
            return ProcessorReader.getCleanCPUModel(cpuinfoLines);
        }
        catch (IOException e) {
            throw new SystemEnvironmentException(e);
        }
    }

    @VisibleForTesting
    static String getCleanCPUModel(List<String> cpuinfoLines) throws UnexpectedFileFormatException {
        Pattern pattern = Pattern.compile("model name\\s*:\\s*(.+)");
        for (String line : cpuinfoLines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return ProcessorReader.cleanUpCPUModel(matcher.group(1));
        }
        throw new UnexpectedFileFormatException("cpuinfo does not contain 'model name'");
    }

    private static String cleanUpCPUModel(String originalModelName) {
        return CharMatcher.WHITESPACE.trimAndCollapseFrom(originalModelName, ' ').replace("(R)", "").replace("(TM)", "").replace("(tm)", "").replace(" Processor", "").replace(" CPU", "").replaceAll("([0-9])GHz", "$1 GHz");
    }
}

