/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.global.worker_health;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.worker_health.WorkerHealth;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class WorkerHealthAnalysis {
    private final WorkerSummary worker;
    private static final MemoryUnit LOW_SPACE_WORKING_DIR = MemoryUnit.gigabyte(3L);
    private static final MemoryUnit CRITICAL_SPACE_WORKING_DIR = MemoryUnit.megabyte(500L);
    private static final MemoryUnit LOW_SPACE_TEMP_DIR = MemoryUnit.gigabyte(1L);
    private WorkerHealth health = WorkerHealth.HEALTHY;
    private List<String> symptoms = Lists.newArrayList();

    public static WorkerHealthAnalysis analyzeHealth(WorkerSummary worker) {
        return new WorkerHealthAnalysis(worker);
    }

    private WorkerHealthAnalysis(WorkerSummary worker) {
        this.worker = Preconditions.checkNotNull(worker);
        this.checkCgroupsAvailability();
        this.checkExcessiveLoad();
        this.checkSuspiciousLoad();
        this.checkFreeSpace();
        this.checkMemory();
    }

    private void checkCgroupsAvailability() {
        if (!this.worker.isCgroupsAvailable()) {
            this.symptoms.add("Cgroups not available.");
            this.updateSickness(WorkerHealth.SICK);
        }
    }

    private void checkExcessiveLoad() {
        float load = this.worker.getLoadData().getLoad1Minute();
        if (load > (float)this.worker.getNumberOfProcessors()) {
            this.symptoms.add("Excessive load: " + this.worker.getLoadData().getLoad1MinuteString());
            this.updateSickness(WorkerHealth.AILING);
        }
    }

    private void checkSuspiciousLoad() {
        if (this.worker.isUsercheckActive() && this.worker.getWorkerState() == ExternalWorkerState.AVAILABLE && this.worker.getExecutorState().getNumberOfPartitions() == 0 && this.worker.getLoadData().getLoad1Minute() > 1.0f) {
            this.symptoms.add("Suspicious load without obvious reason: " + this.worker.getLoadData().getLoad1MinuteString());
            this.updateSickness(WorkerHealth.AILING);
        }
    }

    private void checkFreeSpace() {
        MemoryUnit freeSpaceTempDir;
        MemoryUnit freeSpaceWorkingDir = this.worker.getFreeSpaceWorkingDirectory();
        if (LOW_SPACE_WORKING_DIR.isGreaterEqualThan(freeSpaceWorkingDir)) {
            if (CRITICAL_SPACE_WORKING_DIR.isGreaterEqualThan(freeSpaceWorkingDir)) {
                this.symptoms.add("Dangerously little free space in working dir: " + freeSpaceWorkingDir);
                this.updateSickness(WorkerHealth.SICK);
            } else {
                this.symptoms.add("Warning, only " + freeSpaceWorkingDir + " of free space in working dir.");
                this.updateSickness(WorkerHealth.AILING);
            }
        }
        if (LOW_SPACE_TEMP_DIR.isGreaterEqualThan(freeSpaceTempDir = this.worker.getFreeSpaceTemporaryDir())) {
            this.symptoms.add("Dangerously little free space in temporary dir: " + freeSpaceTempDir);
            this.updateSickness(WorkerHealth.AILING);
        }
    }

    private void checkMemory() {
        if (this.worker.getWorkerState() == ExternalWorkerState.AVAILABLE && this.worker.isUsercheckActive() && !this.worker.getUnusableMemory().isZero() && this.worker.getUsedMemory().isGreaterEqualThan(Constants.SYSTEM_MEMORY)) {
            this.symptoms.add("Memory usage unexpected high: " + this.worker.getUsedMemory());
            this.updateSickness(WorkerHealth.AILING);
        }
    }

    private void updateSickness(WorkerHealth health) {
        this.health = WorkerHealth.moreSick(this.health, health);
    }

    public WorkerHealth getHealth() {
        return this.health;
    }

    public Iterable<String> getSymptoms() {
        return this.symptoms;
    }
}

