/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.help;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Map;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.VerifierCloud;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.StorageFileParser;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationUtils;

public class Help
implements ApplicationService {
    private static final String BASIC_HELP_TEXT = "VerifierCloud is a server-based system for job distribution. It contains integration for CPAchecker, but can be used to execute arbitrary tasks.\nConfiguration files are saved in " + Constants.DEFAULT_USER_CONFIGURATION_FOLDER + ".";
    private static final String DEFAULT_CONFIG = "default-config";
    private final CommandLineArguments commandLineArguments;

    @Inject
    public Help(@Named(value="commandLineArguments") CommandLineArguments commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
    }

    @Override
    public void start() {
        System.out.println(BASIC_HELP_TEXT + "\n");
        if (this.commandLineArguments.isEmpty()) {
            System.out.println(Modes.HELP.getHelpText());
            System.out.println();
        } else {
            String programPath = SystemInformationUtils.getLocalProgramFile().getFileName().toString();
            String programStart = "java -jar " + programPath + " ";
            Map<String, String> namedArguments = this.commandLineArguments.getNamedArguments();
            for (Modes mode : Modes.values()) {
                if (!namedArguments.keySet().contains(mode.getOptionName())) continue;
                System.out.println(mode.getHelpText());
                System.out.println();
                System.out.println("Usage of " + mode.toString() + ":");
                System.out.println(programStart + mode.getOptionName() + " " + mode.getOptions() + '\n');
                System.out.println(mode.getOptionDescription());
                System.out.println();
            }
            if (namedArguments.keySet().contains(DEFAULT_CONFIG)) {
                this.writeDefaultConfigOnStdOut(namedArguments.get(DEFAULT_CONFIG));
            }
        }
        this.stop();
    }

    @Override
    public void stop() {
    }

    private void writeDefaultConfigOnStdOut(String modeString) {
        Optional<Modes> optionalMode = Modes.getProgramModeFromString(modeString);
        if (optionalMode.isPresent()) {
            Logger logger = LoggerBuilder.create().build();
            ImmutableCollection<ConfigurationHandler<?>> handlers = optionalMode.get().getConfigurationHandlers(logger);
            if (handlers.isEmpty()) {
                System.err.print("Mode " + modeString + " does not support print out of default config.\n");
                VerifierCloud.printHelpAndExit();
                return;
            }
            try {
                System.out.println("Default configuration for " + (Object)((Object)optionalMode.get()) + ":");
                for (StorageFileParser storageFileParser : handlers) {
                    storageFileParser.write(System.out);
                }
            }
            catch (IOException e) {
                System.out.println("IO error occourred: " + e.getLocalizedMessage());
            }
        } else {
            System.err.println("Illegal mode " + modeString + ". Cannot print default config.\n");
            VerifierCloud.printHelpAndExit();
        }
    }
}

