/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.help;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;

public class HelpCommandLineOptions {
    public static final String HELP_MODE_OPTION = "help";

    private HelpCommandLineOptions() {
    }

    public static String getOptions() {
        return "[--master|--benchmark|--client|--worker|--cpachecker|--help] [default-config (master|benchmark|client|worker|cpachecker)]";
    }

    public static String getOptionDescription() {
        TableFormatter formater = new TableFormatter(2, 0);
        formater.addRow("--default-config", "Prints the default configuration for the selected mode on std out.");
        formater.addRow("--<mode>", "Prints the possible command line options and its descriptions on std out.");
        return formater.buildTable();
    }

    public static String getHelpText() {
        StringBuilder result = new StringBuilder();
        result.append("To get detailed information about a mode use ");
        result.append("'help --<mode>',");
        result.append(" to see the defaulted configuration use ");
        result.append("'help --default-config <mode>'. \n");
        result.append("Available modes: \n");
        ArrayList<String> availableModes = Lists.newArrayList();
        for (Modes mode : Modes.values()) {
            availableModes.add(mode.getOptionName());
        }
        Joiner.on(", ").appendTo(result, (Iterable<?>)availableModes);
        return result.toString();
    }
}

