/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.help;

import com.google.common.base.Preconditions;
import com.google.inject.name.Names;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.util.system.guice.OperatingSystemSpecificBindingsModule;
import org.sosy_lab.verifiercloud.help.Help;

public class HelpModule
extends AbstractCloudModule {
    private final CommandLineArguments commandLineArguments;

    public HelpModule(CommandLineArguments commandLineArguments) {
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        if (!this.commandLineArguments.getPositionalArguments().isEmpty()) {
            throw new ApplicationInitializationException("Help mode does not support positional arguments");
        }
    }

    @Override
    protected void configure() {
        this.install(new OperatingSystemSpecificBindingsModule());
        this.bind(CommandLineArguments.class).annotatedWith(Names.named("commandLineArguments")).toInstance(this.commandLineArguments);
        Logger logger = LoggerBuilder.create().logToStdError(Level.SEVERE).build();
        this.bind(Logger.class).toInstance(logger);
        this.bind(ApplicationService.class).to(Help.class).asEagerSingleton();
    }
}

