/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ServerInitializationException;
import org.sosy_lab.verifiercloud.global.statistics.StatisticsCollector;
import org.sosy_lab.verifiercloud.global.util.deadlocks.DeadlockDetection;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.clientside.ClientHandler;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultStorage;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultStorageInitializationException;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPool;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPoolListener;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class Master
implements ApplicationService {
    private final Logger logger;
    private final WorkerPool workerPool;
    private final ClientHandler clients;
    private final ConcurrentMasterFileStorage fileStorage;
    private final RunResultStorage runResultStorage;
    private final Path localPath;
    private final SystemInformationProvider sysInfoProvider;
    private final Collection<WorkerStartInformation> workerHosts;
    private final StatisticsCollector statisticsCollector;
    private final ErrorTriggerExecutor errorTriggerExecutor;
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    @Inject
    public Master(@Named(value="workerHosts") Collection<WorkerStartInformation> workerHosts, @Named(value="local-path") Path localPath, Logger logger, WorkerPool workerPool, ClientHandler clientHandler, WorkerPoolListener workerPoolListener, ConcurrentMasterFileStorage fileStorage, SystemInformationProvider sysInfoProvider, RunResultStorage runResultStorage, StatisticsCollector statisticsCollector, ErrorTriggerExecutor errorTriggerExecutor) {
        this.logger = Preconditions.checkNotNull(logger);
        this.sysInfoProvider = sysInfoProvider;
        this.workerPool = Preconditions.checkNotNull(workerPool);
        this.clients = Preconditions.checkNotNull(clientHandler);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.runResultStorage = Preconditions.checkNotNull(runResultStorage);
        this.localPath = Preconditions.checkNotNull(localPath);
        this.workerHosts = Preconditions.checkNotNull(workerHosts);
        this.statisticsCollector = Preconditions.checkNotNull(statisticsCollector);
        this.errorTriggerExecutor = Preconditions.checkNotNull(errorTriggerExecutor);
        workerPool.addWorkerPoolListener(workerPoolListener);
    }

    @Override
    public void start() {
        boolean fail = false;
        try {
            this.logger.logf(Level.INFO, "Starting master on %s.", this.sysInfoProvider.getHostname());
        }
        catch (UnknownHostException e) {
            this.logger.logf(Level.SEVERE, "Starting master failed. Could not determine hostname.", new Object[0]);
            fail = true;
        }
        DeadlockDetection deadlockDetection = new DeadlockDetection(this.errorTriggerExecutor, this.logger);
        deadlockDetection.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Master.this.logger.logf(Level.INFO, "Master executes shutdown hook.", new Object[0]);
                Master.this.stop();
            }
        }));
        try {
            Path workingDirectory = this.initializeWorkingDirectory(this.localPath);
            this.fileStorage.initializeFileStorage(workingDirectory);
        }
        catch (IOException e) {
            this.logger.logf(Level.SEVERE, "Failed to create working directory: %s", e.getMessage());
            fail = true;
        }
        try {
            this.workerPool.startProcessingAndInitializeWorkers(this.workerHosts);
        }
        catch (ServerInitializationException e) {
            this.logger.logf(Level.SEVERE, "Cannot start server for Workers: %s", e.getMessage());
            fail = true;
        }
        try {
            this.clients.startClientHandling();
        }
        catch (ServerInitializationException e) {
            this.logger.logf(Level.SEVERE, "Cannot start server for Clients: %s", e.getMessage());
            fail = true;
        }
        try {
            this.runResultStorage.initialize();
        }
        catch (RunResultStorageInitializationException e) {
            this.logger.logf(Level.SEVERE, "Failed to initialize run result storage: %s", e.getMessage());
            fail = true;
        }
        if (fail) {
            this.stop();
        }
    }

    private Path initializeWorkingDirectory(Path workingDirectory) throws IOException {
        Files.createDirectories(workingDirectory, new FileAttribute[0]);
        return workingDirectory;
    }

    @Override
    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            this.logger.logf(Level.INFO, "Stopping master.", new Object[0]);
            this.workerPool.stopProcessingAndKillWorkers();
            this.clients.stopClientHandling();
            for (String statistic : this.statisticsCollector.getStatistics()) {
                this.logger.logf(Level.INFO, statistic, new Object[0]);
            }
            try {
                this.logger.close();
            }
            catch (IOException e) {
                System.err.println("Can not close logger:");
                e.printStackTrace();
            }
        }
    }
}

