/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.ProgramModeFactory;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;
import org.sosy_lab.verifiercloud.master.MasterModule;
import org.sosy_lab.verifiercloud.master.configuration.MasterConfiguration;
import org.sosy_lab.verifiercloud.master.configuration.workers.WorkerInformationHandler;

public class MasterFactory
implements ProgramModeFactory {
    @Override
    public String getOptions() {
        return MasterConfiguration.getOptions() + WorkerInformationHandler.getOptions();
    }

    @Override
    public String getHelpText() {
        return "Clients can connect to the Master to start Tasks, which are then automatically started on Workers. The Master is responsible for starting Workers and for scheduling Runs on those Workers.";
    }

    @Override
    public String getOptionDescription() {
        TableFormatter formatter = new TableFormatter(2, 0);
        for (ConfigurationOption configurationOption : MasterConfiguration.getConfigurationOptions()) {
            formatter.addRow("--" + configurationOption.getName(), configurationOption.getDescription());
        }
        formatter.addRow("--hosts", "Sets the initial set of worker hosts as a comma separated list.");
        return formatter.buildTable();
    }

    @Override
    public AbstractCloudModule createModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        return new MasterModule(commandLineArguments, userConfigurationPath);
    }

    @Override
    public ImmutableCollection<ConfigurationHandler<?>> getConfigurationHandlers(Logger logger) {
        return ImmutableList.of(new DefaultConfigurationHandler<MasterConfiguration>(MasterConfiguration.getDefaultConfigurationBuilder(), logger));
    }
}

