/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master;

import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.ExecuteErrorTriggerUncaughtExceptionHandler;
import org.sosy_lab.verifiercloud.global.application.StopAppAndExecuteErrorTriggerUncaughtExceptionHandler;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.statistics.DefaultStatisticsCollector;
import org.sosy_lab.verifiercloud.global.statistics.StatisticsCollector;
import org.sosy_lab.verifiercloud.global.util.error_trigger.DefaultErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.system.guice.OperatingSystemSpecificBindingsModule;
import org.sosy_lab.verifiercloud.master.Master;
import org.sosy_lab.verifiercloud.master.clientside.ClientHandler;
import org.sosy_lab.verifiercloud.master.clientside.ClientToMasterAPI;
import org.sosy_lab.verifiercloud.master.clientside.DefaultClientHandler;
import org.sosy_lab.verifiercloud.master.clientside.DefaultClientToMasterAPI;
import org.sosy_lab.verifiercloud.master.clientside.results.InMemoryRunResultManagement;
import org.sosy_lab.verifiercloud.master.clientside.results.NullRunResultStorage;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultManagement;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultStorage;
import org.sosy_lab.verifiercloud.master.clientside.results.ZipRunResultStorage;
import org.sosy_lab.verifiercloud.master.configuration.MasterConfiguration;
import org.sosy_lab.verifiercloud.master.configuration.workers.WorkerInformationHandler;
import org.sosy_lab.verifiercloud.master.files.ConcurrentBufferingCachingMasterFileStorage;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.info.DefaultMasterInformationProvider;
import org.sosy_lab.verifiercloud.master.info.MasterInformationProvider;
import org.sosy_lab.verifiercloud.master.scheduler.DefaultScheduler;
import org.sosy_lab.verifiercloud.master.scheduler.Scheduler;
import org.sosy_lab.verifiercloud.master.workerside.DefaultWorkerPool;
import org.sosy_lab.verifiercloud.master.workerside.DefaultWorkerToMasterAPI;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPool;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPoolListener;
import org.sosy_lab.verifiercloud.master.workerside.WorkerToMasterAPI;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.DefaultWorkerDispatcher;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.DefaultWorkerStarter;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerDispatcher;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerStarter;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class MasterModule
extends AbstractCloudModule {
    private static final String MASTER_CONFIG_FILE = "Config";
    private static final String WORKER_INFORMATION_FILENAME = "WorkerInformation";
    private Collection<WorkerStartInformation> workerHosts;
    private CommandLineArguments commandLineArguments;
    private final InitialLogger logger;
    private PermanentStorage permanentStorage;
    private MasterConfiguration configuration;

    public MasterModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) {
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
        this.logger = LoggerBuilder.createInitialLogger();
        Path masterPermanentStoragePath = userConfigurationPath.resolve("master");
        this.permanentStorage = new DefaultPermanentStorage(masterPermanentStoragePath, this.logger);
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        try {
            this.permanentStorage.initialize();
        }
        catch (PermanentStorageException e) {
            throw new ApplicationInitializationException(e);
        }
        try {
            DefaultConfigurationHandler<MasterConfiguration> confHandler = new DefaultConfigurationHandler<MasterConfiguration>(MasterConfiguration.getDefaultConfigurationBuilder(), this.logger);
            this.permanentStorage.parseFile(MASTER_CONFIG_FILE, confHandler);
            WorkerInformationHandler workerInfoHandler = new WorkerInformationHandler();
            this.permanentStorage.parseFile(WORKER_INFORMATION_FILENAME, workerInfoHandler);
            CommandLineArguments remainingArguments = confHandler.claimParameters(this.commandLineArguments);
            remainingArguments = workerInfoHandler.claimParameters(remainingArguments);
            if (!remainingArguments.isEmpty()) {
                throw new ApplicationInitializationException("Can not handle the following parameters:" + remainingArguments);
            }
            this.configuration = (MasterConfiguration)confHandler.getParseResult();
            this.workerHosts = workerInfoHandler.getParseResult();
        }
        catch (InvalidOptionException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e);
        }
        try {
            LoggerBuilder loggerBuilder = LoggerBuilder.create().logAsynchronously().logToStdOut(this.configuration.getLogLevel()).logExceptionsToErrorTrigger(this.configuration.getErrorTriggerCommand(), Level.WARNING);
            if (this.configuration.isLogFileCompressed()) {
                loggerBuilder.logToCompressedFile(this.configuration.getFileLogPath(), this.configuration.getFileLogLevel());
            } else {
                loggerBuilder.logToFile(this.configuration.getFileLogPath(), this.configuration.getFileLogLevel());
            }
            loggerBuilder.injectInto(this.logger);
        }
        catch (IOException e) {
            throw new ApplicationInitializationException(e);
        }
        AbstractFileContent.setDeserializationPath(this.configuration.getLocalPath().resolve("BigFileContentTmp"));
        AbstractFileContent.setWriteRepresentationOnDeserialisation(true);
    }

    @Override
    public void configure() {
        this.install(this.configuration);
        this.install(new OperatingSystemSpecificBindingsModule());
        this.bind(new TypeLiteral<Collection<WorkerStartInformation>>(){}).annotatedWith(Names.named("workerHosts")).toInstance(this.workerHosts);
        this.bind(ApplicationService.class).to(Master.class).asEagerSingleton();
        this.bind(Logger.class).toInstance(this.logger);
        this.bind(StatisticsCollector.class).to(DefaultStatisticsCollector.class).asEagerSingleton();
        this.bind(ClientHandler.class).to(DefaultClientHandler.class).asEagerSingleton();
        this.bind(RunResultManagement.class).to(InMemoryRunResultManagement.class).asEagerSingleton();
        this.bind(ClientToMasterAPI.class).to(DefaultClientToMasterAPI.class).asEagerSingleton();
        this.bind(WorkerPool.class).to(DefaultWorkerPool.class);
        this.bind(WorkerDispatcher.class).to(DefaultWorkerDispatcher.class);
        this.bind(WorkerStarter.class).to(DefaultWorkerStarter.class);
        this.bind(WorkerToMasterAPI.class).to(DefaultWorkerToMasterAPI.class);
        this.bind(Scheduler.class).to(DefaultScheduler.class);
        this.bind(WorkerPoolListener.class).to(DefaultScheduler.class);
        this.bind(ConcurrentMasterFileStorage.class).to(ConcurrentBufferingCachingMasterFileStorage.class);
        this.bind(MasterInformationProvider.class).to(DefaultMasterInformationProvider.class);
        this.bind(PermanentStorage.class).toInstance(this.permanentStorage);
        if (this.configuration.isZipRunResultStoringEnabled()) {
            this.bind(RunResultStorage.class).to(ZipRunResultStorage.class);
        } else {
            this.bind(RunResultStorage.class).to(NullRunResultStorage.class);
        }
        this.bind(Thread.UncaughtExceptionHandler.class).annotatedWith(Names.named("error-trigger")).to(ExecuteErrorTriggerUncaughtExceptionHandler.class);
        this.bind(Thread.UncaughtExceptionHandler.class).to(StopAppAndExecuteErrorTriggerUncaughtExceptionHandler.class);
        this.bind(ErrorTriggerExecutor.class).to(DefaultErrorTriggerExecutor.class);
        this.bind(DefaultScheduler.class).asEagerSingleton();
        this.bind(DefaultWorkerPool.class).asEagerSingleton();
        this.bind(DefaultWorkerToMasterAPI.class).asEagerSingleton();
        this.bind(ConcurrentBufferingCachingMasterFileStorage.class).asEagerSingleton();
    }
}

