/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.clientside;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ConnectionAcceptor;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ServerInitializationException;
import org.sosy_lab.verifiercloud.global.networking.interaction.AsyncIncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.master.clientside.ClientHandler;
import org.sosy_lab.verifiercloud.master.clientside.ClientToMasterAPI;
import org.sosy_lab.verifiercloud.master.clientside.client.ClientAbstraction;
import org.sosy_lab.verifiercloud.master.clientside.client.ConnectionLostListener;
import org.sosy_lab.verifiercloud.master.clientside.user.AuthorizationService;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.networking.Server;

public class DefaultClientHandler
implements ClientHandler {
    private final List<ClientAbstraction> connectedClients = Collections.synchronizedList(new LinkedList());
    private final Logger logger;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private ConcurrentMasterFileStorage fileStorage;
    private final Server clientServer;
    private final IncomingCommandHandler<ClientToMasterAPI> incQueue;
    private final AtomicInteger idCounter = new AtomicInteger(0);
    private final AuthorizationService authorizationModule;

    @Inject
    public DefaultClientHandler(ClientToMasterAPI api, @Named(value="client-to-master-port") Integer clientToMasterPort, ConcurrentMasterFileStorage fileStorage, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        this.clientServer = new Server(clientToMasterPort, new ClientConnectionAcceptor(), uncaughtExceptionHandler, logger);
        this.authorizationModule = new AuthorizationService(logger);
        this.incQueue = new AsyncIncomingCommandHandler<ClientToMasterAPI>(api, uncaughtExceptionHandler, logger);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void startClientHandling() throws ServerInitializationException {
        this.incQueue.start();
        this.clientServer.startServer();
    }

    @Override
    public void stopClientHandling() {
        this.clientServer.stopServer();
        this.incQueue.stop();
        ImmutableList<ClientAbstraction> clients = ImmutableList.copyOf(this.connectedClients);
        for (ClientAbstraction client : clients) {
            client.informAboutMasterShutdown();
            client.terminateCommunication();
        }
    }

    @Override
    public int getNumberOfClients() {
        return this.connectedClients.size();
    }

    private class ClientConnectionLostListener
    implements ConnectionLostListener {
        private ClientConnectionLostListener() {
        }

        @Override
        public void connectionLost(ClientAbstraction client) {
            if (DefaultClientHandler.this.connectedClients.remove(client)) {
                DefaultClientHandler.this.logger.logf(Level.FINE, "%s disconnected.", client);
            } else {
                DefaultClientHandler.this.logger.logf(Level.SEVERE, "Lost connection to unknown client %s.", client);
            }
        }
    }

    private class ClientConnectionAcceptor
    implements ConnectionAcceptor {
        private ClientConnectionAcceptor() {
        }

        @Override
        public void acceptSocket(Socket socket) {
            String clientId = String.valueOf(DefaultClientHandler.this.idCounter.getAndIncrement());
            ClientAbstraction newClient = new ClientAbstraction(socket, DefaultClientHandler.this.incQueue, clientId, DefaultClientHandler.this.authorizationModule, DefaultClientHandler.this.fileStorage, DefaultClientHandler.this.uncaughtExceptionHandler, DefaultClientHandler.this.logger);
            newClient.registerConnectionLostListener(new ClientConnectionLostListener());
            newClient.startCommunication();
            DefaultClientHandler.this.connectedClients.add(newClient);
            DefaultClientHandler.this.logger.logf(Level.FINE, "%s connected.", newClient);
        }
    }
}

