/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.clientside;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.master.clientside.ClientToMasterAPI;
import org.sosy_lab.verifiercloud.master.clientside.client.ClientAbstraction;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultManagement;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultStorage;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.info.MasterInformationProvider;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPool;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.AccessDeniedCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RequestFailedCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RequestSuccessfulCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RunCollectionScheduledCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RunResultAsZipCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.SendMasterSummaryCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.SendResultFileCommand;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class DefaultClientToMasterAPI
implements ClientToMasterAPI {
    private static final Level RIGHTS_VIOLATION_LOG_LEVEL = Level.WARNING;
    private static final Level USER_INTERACTION_LOG_LEVEL = Level.FINE;
    private static final Level ADMINISTRATION_LOG_LEVEL = Level.INFO;
    private final int maxRunInputFiles;
    private final Logger logger;
    private final ApplicationService stopableMaster;
    private final RunResultManagement runResultManagement;
    private final RunResultStorage runResultStorage;
    private final ConcurrentMasterFileStorage fileStorage;
    private final WorkerPool workerPool;
    private final Map<RunCollection, ClientAbstraction> stagedRunCollections;
    private final Map<RunCollection, Boolean> stagedRunCollectionsDetachable;
    private final Map<RunCollection, UUID> stagedRunCollectionsRequestId;
    private final MasterInformationProvider masterInformationProvider;

    @Inject
    public DefaultClientToMasterAPI(ApplicationService stopableMaster, RunResultManagement runResultManagement, RunResultStorage runResultStorage, MasterInformationProvider masterInformationProvider, ConcurrentMasterFileStorage fileStorage, WorkerPool workerPool, Logger logger, @Named(value="max-run-input-files") Integer maxRunInputFiles) {
        this.runResultManagement = Preconditions.checkNotNull(runResultManagement);
        this.runResultStorage = Preconditions.checkNotNull(runResultStorage);
        this.masterInformationProvider = Preconditions.checkNotNull(masterInformationProvider);
        this.logger = Preconditions.checkNotNull(logger);
        this.maxRunInputFiles = maxRunInputFiles;
        this.stopableMaster = Preconditions.checkNotNull(stopableMaster);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.workerPool = Preconditions.checkNotNull(workerPool);
        this.stagedRunCollections = Collections.synchronizedMap(new HashMap());
        this.stagedRunCollectionsDetachable = Collections.synchronizedMap(new HashMap());
        this.stagedRunCollectionsRequestId = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRunCollection(ClientAbstraction client, RunCollection runCollection, boolean detachable, UUID requestId) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.USER)) {
            client.sendCommand(new AccessDeniedCommand(requestId));
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to add run collection but has insufficient rights.", client);
            return;
        }
        if (!this.runResultStorage.isResultStoringSupported()) {
            for (Run run : runCollection.getRuns()) {
                if (!run.storeResultOnMaster()) continue;
                client.sendCommand(new RequestFailedCommand("Master does not support run result storing.", requestId));
                return;
            }
        }
        for (Run run : runCollection.getRuns()) {
            if (run.getFileHierarchy().size() <= this.maxRunInputFiles) continue;
            client.sendCommand(new RequestFailedCommand("Only " + this.maxRunInputFiles + " files are allowed as input for a run.", requestId));
            return;
        }
        this.logger.logf(USER_INTERACTION_LOG_LEVEL, "%s is adding %s.", client, runCollection);
        ImmutableSet<HashCode> fileHashes = runCollection.getAllRequiredFileHashes();
        client.requestFiles(fileHashes);
        Map<RunCollection, ClientAbstraction> map = this.stagedRunCollections;
        synchronized (map) {
            this.stagedRunCollections.put(runCollection, client);
            this.stagedRunCollectionsDetachable.put(runCollection, detachable);
            this.stagedRunCollectionsRequestId.put(runCollection, requestId);
        }
        this.scheduleStagedRunCollectionsIfAllFilesAreAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleStagedRunCollectionsIfAllFilesAreAvailable() {
        LinkedList<RunCollection> runCollectionsReadyToStart = Lists.newLinkedList();
        Map<RunCollection, ClientAbstraction> map = this.stagedRunCollections;
        synchronized (map) {
            for (RunCollection runCollection : this.stagedRunCollections.keySet()) {
                if (!this.isRunCollectionReadyToStart(runCollection)) continue;
                runCollectionsReadyToStart.add(runCollection);
            }
            for (RunCollection runCollection : runCollectionsReadyToStart) {
                UUID requestId = this.stagedRunCollectionsRequestId.remove(runCollection);
                boolean detachable = this.stagedRunCollectionsDetachable.remove(runCollection);
                ClientAbstraction client = this.stagedRunCollections.remove(runCollection);
                if (detachable || client.isAlive()) {
                    int numberOfRuns = runCollection.getRuns().size();
                    this.logger.logf(Level.FINER, "Adding %s with %s runs to Scheduler.", runCollection, numberOfRuns);
                    this.runResultManagement.addRunCollection(runCollection, detachable, client);
                    client.sendCommand(new RunCollectionScheduledCommand(requestId));
                    continue;
                }
                this.logger.logf(Level.INFO, "%s is not allive, removing %s.", client, runCollection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunCollectionReadyToStart(RunCollection runCollection) {
        ConcurrentMasterFileStorage concurrentMasterFileStorage = this.fileStorage;
        synchronized (concurrentMasterFileStorage) {
            for (HashCode requiredFile : runCollection.getAllRequiredFileHashes()) {
                if (this.fileStorage.isFileKnown(requiredFile)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void stopRunCollection(ClientAbstraction client, String id, UUID requestID) {
        boolean success;
        Optional<ClientAbstraction> clientOfRunCollection = this.runResultManagement.getClientForRunCollection(id);
        if (clientOfRunCollection.isPresent() && clientOfRunCollection.get().equals(client)) {
            if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.USER)) {
                this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to stop run collection with id %s, but has insufficient rights.", client, id);
                client.sendCommand(new AccessDeniedCommand(requestID));
                return;
            }
        } else if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.ADMIN)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to stop run collection with id %s, but has insufficient rights.", client, id);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        if (success = this.runResultManagement.stopRunCollection(id)) {
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s stopped run collection with id %s.", client, id);
            client.sendCommand(new RequestSuccessfulCommand(requestID));
        } else {
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "Unsuccessful attempt to stop run collection with id %s by %s.", id, client);
            client.sendCommand(new RequestFailedCommand("RunCollection with id " + id + " unknown.", requestID));
        }
    }

    @Override
    public void sendFile(ClientAbstraction client, FileContent fileContent) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.USER)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to send file but has insufficient rights.", client);
            return;
        }
        try {
            HashCode hashOfFile = this.fileStorage.addFile(Preconditions.checkNotNull(fileContent));
            this.logger.logf(USER_INTERACTION_LOG_LEVEL, "Received the file %s from %s.", hashOfFile, client);
            this.scheduleStagedRunCollectionsIfAllFilesAreAvailable();
        }
        catch (IOException e) {
            this.logger.logf(Level.SEVERE, e, "IOException when writing file to disc: %s", e.getMessage());
            this.stopableMaster.stop();
        }
    }

    @Override
    public void requestFile(final ClientAbstraction client, final HashCode fileHash, final UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.USER)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to get file but has insufficient rights.", client);
            return;
        }
        if (this.fileStorage.isFileKnown(fileHash)) {
            ListenableFuture<FileContent> fileContentFuture = this.fileStorage.getFileContent(fileHash);
            Futures.addCallback(fileContentFuture, new FutureCallback<FileContent>(){

                @Override
                public void onSuccess(FileContent result) {
                    SendResultFileCommand cmd = new SendResultFileCommand(result, requestID);
                    client.sendCommand(cmd);
                    DefaultClientToMasterAPI.this.logger.logf(Level.FINEST, "Sent file %s to %s.", fileHash, client);
                }

                @Override
                public void onFailure(Throwable t) {
                    DefaultClientToMasterAPI.this.logger.logf(Level.SEVERE, t, "File could not be retrieved: %s", t.getMessage());
                    DefaultClientToMasterAPI.this.stopableMaster.stop();
                }
            });
        } else {
            this.logger.logf(Level.WARNING, "%s requested file with hash %s, which is not available.", client, fileHash);
            client.sendCommand(new RequestFailedCommand("File with hash " + fileHash + " is not available.", requestID));
        }
    }

    private boolean hasRequiredAccessLevel(ClientAbstraction client, ClientAccessLevel requiredLevel) {
        ClientAccessLevel clientLevel = client.getAccessLevel();
        return ClientAccessLevel.isSufficientLevel(requiredLevel, clientLevel);
    }

    @Override
    public void authenticateUser(ClientAbstraction client, ClientAccessLevel desiredLevel, String username, UUID requestId) {
        Preconditions.checkNotNull(client);
        Preconditions.checkNotNull(username);
        client.authenticate(desiredLevel, username, requestId);
    }

    @Override
    public void requestMasterSummary(ClientAbstraction client, UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.USER)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s requested master summary but has insufficient rights.", client);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        MasterSummary masterSummary = this.masterInformationProvider.collectMasterSummary();
        SendMasterSummaryCommand command = new SendMasterSummaryCommand(masterSummary, requestID);
        client.sendCommand(command);
        this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s requested information.", client);
    }

    @Override
    public void stopMaster(ClientAbstraction client, UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.ADMIN)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to stop Master but has insufficient rights.", client);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        client.sendCommand(new RequestSuccessfulCommand(requestID));
        this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s is stopping Master.", client);
        this.stopableMaster.stop();
    }

    @Override
    public void addWorker(ClientAbstraction client, WorkerStartInformation workerStartInformation, UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.ADMIN)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to start worker but has insufficient rights.", client);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s is adding %s.", client, workerStartInformation);
        Preconditions.checkNotNull(workerStartInformation);
        this.workerPool.addWorker(workerStartInformation);
        client.sendCommand(new RequestSuccessfulCommand(requestID));
    }

    @Override
    public void removeWorker(ClientAbstraction client, String hostname, UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.ADMIN)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to stop worker but has insufficient rights.", client);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        if (Strings.isNullOrEmpty(hostname)) {
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s tried to remove empty hostname from workerlist.", client);
            return;
        }
        boolean successOfRemoval = this.workerPool.removeWorker(hostname);
        if (successOfRemoval) {
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s removed %s from list of available workers.", client, hostname);
            client.sendCommand(new RequestSuccessfulCommand(requestID));
        } else {
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s tried to remove non-existant %s from list of available workers.", client, hostname);
            client.sendCommand(new RequestFailedCommand("Worker " + hostname + " is unknown.", requestID));
        }
    }

    @Override
    public void changeRunCollectionPriority(ClientAbstraction client, String runCollectionId, SchedulingPriority priority, UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.ADMIN)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to change priority of RunCollection %s, but has insufficient rights.", client, runCollectionId);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        boolean successfullyChanged = this.runResultManagement.changeRunCollectionPriority(runCollectionId, priority);
        if (successfullyChanged) {
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s has changed priority of RunCollection %s to %s.", new Object[]{client, runCollectionId, priority});
            client.sendCommand(new RequestSuccessfulCommand(requestID));
        } else {
            client.sendCommand(new RequestFailedCommand("RunCollection with id " + runCollectionId + " does not exist.", requestID));
            this.logger.logf(ADMINISTRATION_LOG_LEVEL, "%s wanted to change priority of non-existant RunCollection %s.", client, runCollectionId);
        }
    }

    @Override
    public void requestRunResultAsZip(ClientAbstraction client, String runID, UUID requestID) {
        if (!this.hasRequiredAccessLevel(client, ClientAccessLevel.USER)) {
            this.logger.logf(RIGHTS_VIOLATION_LOG_LEVEL, "%s tried to request result of Run %s, but has insufficient rights.", client, runID);
            client.sendCommand(new AccessDeniedCommand(requestID));
            return;
        }
        if (this.runResultStorage.isResultAvailable(runID)) {
            try {
                FileContent resultZipFile = this.runResultStorage.getResults(runID);
                RunResultAsZipCommand message = new RunResultAsZipCommand(runID, resultZipFile, requestID);
                client.sendCommand(message);
            }
            catch (IOException e) {
                this.logger.logf(Level.SEVERE, e, "IO eror while reading result as zip: %s", e.getMessage());
                this.stopableMaster.stop();
            }
        } else {
            client.sendCommand(new RequestFailedCommand("Result with id " + runID + " is not available.", requestID));
        }
    }
}

