/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.clientside.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionListener;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.NetworkAbstraction;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.master.clientside.ClientToMasterAPI;
import org.sosy_lab.verifiercloud.master.clientside.client.ConnectionLostListener;
import org.sosy_lab.verifiercloud.master.clientside.user.AuthorizationService;
import org.sosy_lab.verifiercloud.master.clientside.user.AuthorizedUser;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.transportable.commands.client_to_master.ClientToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.MasterToClientCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RequestAndDeclineFilesCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.UpdateClientAuthStateCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.ShutdownInformationCommand;

public class ClientAbstraction
extends NetworkAbstraction<ClientToMasterCommand, MasterToClientCommand, ClientToMasterAPI> {
    private final Logger logger;
    private final ConcurrentMasterFileStorage fileStorage;
    private final AuthorizationService authorizationModule;
    private final Collection<ConnectionLostListener> listeners;
    private final String hostAddress;
    private final int hostPort;
    private final String clientId;
    private final Set<HashCode> requestedFiles = Sets.newHashSet();
    private volatile AuthorizedUser authorizedUser = AuthorizationService.getUnauthorizedDefaultUser();

    public ClientAbstraction(Socket socket, IncomingCommandHandler<ClientToMasterAPI> incQueue, String clientId, AuthorizationService authorizationModule, ConcurrentMasterFileStorage fileStorage, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        super(socket, uncaughtExceptionHandler, logger, ClientToMasterCommand.class);
        this.hostAddress = socket.getInetAddress().getHostAddress();
        this.hostPort = socket.getPort();
        this.clientId = clientId;
        this.authorizationModule = Preconditions.checkNotNull(authorizationModule);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.logger = Preconditions.checkNotNull(logger);
        this.addConnectionListener(new ClientConnectionListener(incQueue));
        ArrayList listeners = Lists.newArrayList();
        this.listeners = Collections.synchronizedCollection(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionLostListener(ConnectionLostListener listener) {
        Collection<ConnectionLostListener> collection = this.listeners;
        synchronized (collection) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void informAboutMasterShutdown() {
        this.sendCommand(new ShutdownInformationCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFiles(Collection<HashCode> fileHashes) {
        ArrayList<HashCode> filesAlreadyAvailable = Lists.newArrayList();
        ArrayList<HashCode> filesStillRequired = Lists.newArrayList();
        ConcurrentMasterFileStorage concurrentMasterFileStorage = this.fileStorage;
        synchronized (concurrentMasterFileStorage) {
            for (HashCode fileHash : fileHashes) {
                if (this.fileStorage.isFileKnown(fileHash)) {
                    filesAlreadyAvailable.add(fileHash);
                    this.requestedFiles.remove(fileHash);
                    continue;
                }
                if (this.requestedFiles.contains(fileHash)) continue;
                filesStillRequired.add(fileHash);
                this.requestedFiles.add(fileHash);
            }
        }
        if (filesAlreadyAvailable.size() + filesStillRequired.size() > 0) {
            RequestAndDeclineFilesCommand command = new RequestAndDeclineFilesCommand(filesStillRequired, filesAlreadyAvailable);
            this.sendCommand(command);
        }
    }

    public ClientAccessLevel getAccessLevel() {
        return this.authorizedUser.getLevel();
    }

    public void authenticate(ClientAccessLevel desiredLevel, String username, UUID requestId) {
        Preconditions.checkNotNull(username);
        Preconditions.checkNotNull(desiredLevel);
        this.authorizedUser = this.authorizationModule.authorizeUser(desiredLevel, username);
        ClientAccessLevel level = this.authorizedUser.getLevel();
        this.logger.logf(Level.INFO, "%s authenticated as %s to level %s.", new Object[]{this, username, level});
        this.sendCommand(new UpdateClientAuthStateCommand(level, requestId));
    }

    public AuthorizedUser getAuthorizedUser() {
        return this.authorizedUser;
    }

    public String toString() {
        return String.format("Client[%s,%s:%s,%s]", this.clientId, this.hostAddress, this.hostPort, this.authorizedUser);
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.clientId.hashCode();
    }

    private class ClientConnectionListener
    implements ConnectionListener<ClientToMasterCommand> {
        private final IncomingCommandHandler<ClientToMasterAPI> incomingCommandHandler;

        public ClientConnectionListener(IncomingCommandHandler<ClientToMasterAPI> incQueue) {
            this.incomingCommandHandler = Preconditions.checkNotNull(incQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed() {
            Collection collection = ClientAbstraction.this.listeners;
            synchronized (collection) {
                for (ConnectionLostListener listener : ClientAbstraction.this.listeners) {
                    listener.connectionLost(ClientAbstraction.this);
                }
            }
        }

        @Override
        public void messageReceived(ClientToMasterCommand message) {
            this.incomingCommandHandler.addCommand(ClientAbstraction.this, message);
        }
    }
}

