/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.clientside.results;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.clientside.client.ClientAbstraction;
import org.sosy_lab.verifiercloud.master.clientside.client.ConnectionLostListener;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultManagement;
import org.sosy_lab.verifiercloud.master.clientside.results.RunResultStorage;
import org.sosy_lab.verifiercloud.master.clientside.user.DefaultUser;
import org.sosy_lab.verifiercloud.master.clientside.user.User;
import org.sosy_lab.verifiercloud.master.scheduler.ScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.scheduler.Scheduler;
import org.sosy_lab.verifiercloud.master.scheduler.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RunFailedCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.RunResultCommand;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;

public class InMemoryRunResultManagement
implements RunResultManagement {
    private final Scheduler scheduler;
    private final RunResultStorage runResultStorage;
    private final Logger logger;
    private final Multimap<ClientAbstraction, ScheduledRunCollection> scheduledCollections;
    private final ExecutorService resultExecutor;

    @Inject
    public InMemoryRunResultManagement(Scheduler scheduler, RunResultStorage runResultStorage, Logger logger) {
        this.runResultStorage = Preconditions.checkNotNull(runResultStorage);
        this.logger = Preconditions.checkNotNull(logger);
        this.scheduler = Preconditions.checkNotNull(scheduler);
        this.scheduledCollections = Multimaps.synchronizedSetMultimap(HashMultimap.create());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true).setNameFormat(this.getClass().getSimpleName() + "-pool-%d");
        this.resultExecutor = Executors.newSingleThreadExecutor(tfb.build());
    }

    @Override
    public void addRunCollection(RunCollection runCollection, boolean detachable, ClientAbstraction client) {
        Preconditions.checkNotNull(runCollection);
        Preconditions.checkNotNull(client);
        User user = runCollection.getUserName().isPresent() ? new DefaultUser(runCollection.getUserName().get()) : client.getAuthorizedUser().getUser();
        ScheduledRunCollection scheduledRunCollection = this.scheduler.addRunCollection(runCollection, user, detachable);
        this.scheduledCollections.put(client, scheduledRunCollection);
        client.registerConnectionLostListener(new ClientConnectionLostListener());
        RunCallback runCollectionCallback = new RunCallback(client, scheduledRunCollection);
        for (ListenableFuture<RunResult> result : scheduledRunCollection.getResults()) {
            Futures.addCallback(result, runCollectionCallback, this.resultExecutor);
        }
    }

    @Override
    public Optional<ClientAbstraction> getClientForRunCollection(String runCollectionId) {
        Optional<ScheduledRunCollection> scheduledRunCollection = this.getRunCollection(runCollectionId);
        if (scheduledRunCollection.isPresent()) {
            return this.getClientAbstraction(scheduledRunCollection.get());
        }
        return Optional.absent();
    }

    @Override
    public boolean changeRunCollectionPriority(String runCollectionId, SchedulingPriority priority) {
        Preconditions.checkNotNull(runCollectionId);
        Preconditions.checkNotNull(priority);
        Optional<ScheduledRunCollection> rc = this.getRunCollection(runCollectionId);
        if (rc.isPresent()) {
            ScheduledRunCollection runCollection = rc.get();
            runCollection.setPriority(priority);
            return true;
        }
        return false;
    }

    private Optional<ScheduledRunCollection> getRunCollection(String id) {
        return FluentIterable.from(this.scheduledCollections.values()).firstMatch(new ScheduledRunCollectionByIdPredicate(id));
    }

    @Override
    public boolean stopRunCollection(String runCollectionId) {
        Preconditions.checkNotNull(runCollectionId);
        Optional<ScheduledRunCollection> possibleRunCollection = this.getRunCollection(runCollectionId);
        if (possibleRunCollection.isPresent()) {
            ScheduledRunCollection scheduledRunCollection = possibleRunCollection.get();
            scheduledRunCollection.cancelRunCollection();
            Optional<ClientAbstraction> client = this.getClientAbstraction(scheduledRunCollection);
            if (client.isPresent() && this.scheduledCollections.remove(client.get(), scheduledRunCollection)) {
                this.logger.logf(Level.FINEST, "Removed %s from scheduling list.", scheduledRunCollection.getRunCollection());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ClientAbstraction> getClientAbstraction(ScheduledRunCollection scheduledRunCollection) {
        Multimap<ClientAbstraction, ScheduledRunCollection> multimap = this.scheduledCollections;
        synchronized (multimap) {
            for (Map.Entry<ClientAbstraction, ScheduledRunCollection> entry : this.scheduledCollections.entries()) {
                if (!entry.getValue().equals(scheduledRunCollection)) continue;
                return Optional.of(entry.getKey());
            }
        }
        return Optional.absent();
    }

    private static final class IsScheduledRunCollectionNotDetachablePredicate
    implements Predicate<ScheduledRunCollection> {
        private IsScheduledRunCollectionNotDetachablePredicate() {
        }

        @Override
        public boolean apply(@Nonnull ScheduledRunCollection scheduledRunCollections) {
            Preconditions.checkNotNull(scheduledRunCollections);
            return !scheduledRunCollections.isDetachable();
        }
    }

    private static final class ScheduledRunCollectionByIdPredicate
    implements Predicate<ScheduledRunCollection> {
        private final String id;

        private ScheduledRunCollectionByIdPredicate(String id) {
            this.id = id;
        }

        @Override
        public boolean apply(@Nonnull ScheduledRunCollection input) {
            Preconditions.checkNotNull(input);
            return input.getRunCollection().getId().equals(this.id);
        }
    }

    private class ClientConnectionLostListener
    implements ConnectionLostListener {
        private ClientConnectionLostListener() {
        }

        @Override
        public void connectionLost(ClientAbstraction client) {
            ImmutableList<ScheduledRunCollection> clientCollections = FluentIterable.from(InMemoryRunResultManagement.this.scheduledCollections.get(client)).filter(new IsScheduledRunCollectionNotDetachablePredicate()).toList();
            for (ScheduledRunCollection runCollection : clientCollections) {
                runCollection.cancelRunCollection();
                if (!InMemoryRunResultManagement.this.scheduledCollections.remove(client, runCollection)) continue;
                InMemoryRunResultManagement.this.logger.logf(Level.FINEST, "Removed %s from scheduling list.", runCollection);
            }
        }
    }

    private final class RunCallback
    implements FutureCallback<RunResult> {
        private final ClientAbstraction client;
        private final AtomicInteger receivedResults = new AtomicInteger(0);
        private final ScheduledRunCollection scheduledRunCollection;
        private final RunCollection runCollection;

        private RunCallback(ClientAbstraction client, ScheduledRunCollection scheduledRunCollection) {
            this.client = client;
            this.scheduledRunCollection = scheduledRunCollection;
            this.runCollection = scheduledRunCollection.getRunCollection();
        }

        @Override
        public void onSuccess(@Nonnull RunResult result) {
            Preconditions.checkNotNull(result);
            RunResultCommand resultCommand = new RunResultCommand(result.getRun(), result);
            if (this.client.isAlive()) {
                this.client.sendCommand(resultCommand);
            } else {
                InMemoryRunResultManagement.this.logger.logf(Level.WARNING, "Cannot send run result %s to %s because connection is lost.", result, this.client);
            }
            if (result.getRun().storeResultOnMaster()) {
                InMemoryRunResultManagement.this.runResultStorage.storeResult(result);
            }
            this.cleanupIfDone();
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.client.isAlive()) {
                if (t instanceof RunCanceledException) {
                    RunCanceledException reason = (RunCanceledException)t;
                    Run run = reason.getRun();
                    this.client.sendCommand(new RunFailedCommand(run, reason));
                } else {
                    InMemoryRunResultManagement.this.logger.logf(Level.WARNING, t, "Run execution failed: %s", t.getMessage());
                }
            }
            this.cleanupIfDone();
        }

        private void cleanupIfDone() {
            boolean removed;
            if (this.receivedResults.incrementAndGet() == this.runCollection.getRuns().size() && (removed = InMemoryRunResultManagement.this.scheduledCollections.remove(this.client, this.scheduledRunCollection))) {
                InMemoryRunResultManagement.this.logger.logf(Level.FINEST, "Removed %s from scheduling list.", this.runCollection);
            }
        }
    }
}

