/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.clientside.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.master.clientside.user.AuthorizedUser;
import org.sosy_lab.verifiercloud.master.clientside.user.DefaultAuthorizedUser;
import org.sosy_lab.verifiercloud.master.clientside.user.UnknownUnauthorizedUser;

public class AuthorizationService {
    private final Map<String, ClientAccessLevel> users = Maps.newHashMap();

    public static AuthorizedUser getUnauthorizedDefaultUser() {
        return new UnknownUnauthorizedUser();
    }

    public AuthorizationService(Logger logger) {
        this.users.put("admin", ClientAccessLevel.ADMIN);
        this.users.put("user", ClientAccessLevel.USER);
    }

    public AuthorizedUser authorizeUser(ClientAccessLevel desiredLevel, String name) {
        Preconditions.checkNotNull(desiredLevel);
        if (Strings.isNullOrEmpty(name)) {
            return AuthorizationService.getUnauthorizedDefaultUser();
        }
        return new DefaultAuthorizedUser(name, desiredLevel);
    }
}

