/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.clientside.user;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.master.clientside.user.AuthorizedUser;
import org.sosy_lab.verifiercloud.master.clientside.user.DefaultUser;
import org.sosy_lab.verifiercloud.master.clientside.user.User;

public class DefaultAuthorizedUser
implements AuthorizedUser {
    private final User user;
    private final ClientAccessLevel level;

    DefaultAuthorizedUser(String name, ClientAccessLevel level) {
        Preconditions.checkNotNull(name);
        this.level = Preconditions.checkNotNull(level);
        this.user = new DefaultUser(name);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isUserKnown() {
        return true;
    }

    @Override
    public ClientAccessLevel getLevel() {
        return this.level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.level});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultAuthorizedUser)) {
            return false;
        }
        DefaultAuthorizedUser other = (DefaultAuthorizedUser)obj;
        return this.level.equals((Object)other.level) && this.user.equals(other.user);
    }

    public String toString() {
        return this.user + ":" + (Object)((Object)this.level);
    }
}

