/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.Configuration;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.GenericTypeConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PortConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.constraints.PositiveIntegerConstraint;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringNotNullFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToBooleanFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToIntegerFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToLevelFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToOptionalFunction;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.string_functions.StringToPathFunction;

public class MasterConfiguration
extends Configuration {
    public static final String STD_OUT_LOGLEVEL = "loglevel";
    private final ConfigurationOption<Level> stdoutLoglevel = new DefaultConfigurationOption<Level>("loglevel", "Sets the log level for logging to standard out.", "(" + Joiner.on("|").join(Logger.POSSIBLE_SETTINGS), Level.FINER, new StringToLevelFunction(), "logLevel");
    public static final String FILE_LOGLEVEL = "file-loglevel";
    private final ConfigurationOption<Level> fileLoglevel = new DefaultConfigurationOption<Level>("file-loglevel", "Sets the log level for logging to a file. Does not log to file if set to OFF.", "(" + Joiner.on("|").join(Logger.POSSIBLE_SETTINGS) + ")", Level.OFF, new StringToLevelFunction());
    public static final String FILE_LOG_PATH = "file-log-path";
    private final ConfigurationOption<Path> fileLogPath = new DefaultConfigurationOption<Path>("file-log-path", "Sets the path for a directory where log files are saved.", "<path>", Paths.get("master-logs", new String[0]), new StringToPathFunction(), Path.class);
    public static final String COMPRESSED_FILE_LOGIN = "compressed-file-logging";
    private final ConfigurationOption<Boolean> compressedFileLogging = new DefaultConfigurationOption<Boolean>("compressed-file-logging", "Sets whether the log file is compressed or not.", "(true | false)", false, new StringToBooleanFunction());
    public static final String LOCAL_PATH = "local-path";
    private final ConfigurationOption<Path> localPath = new DefaultConfigurationOption<Path>("local-path", "Sets the path where the master stores files.", "<path>", Paths.get(Constants.DEFAULT_MASTER_WORKING_FOLDER, new String[0]), new StringToPathFunction(), Path.class);
    public static final String WORKER_TO_MASTER_PORT = "worker-to-master-port";
    private final ConfigurationOption<Integer> workerToMasterPort = new DefaultConfigurationOption<Integer>("worker-to-master-port", "Sets the port number where the master accepts connections from workers.", "port", Integer.valueOf(15141), new StringToIntegerFunction(), new PortConstraint());
    public static final String CLIENT_TO_MASTER_PORT = "client-to-master-port";
    private final ConfigurationOption<Integer> clientToMasterPort = new DefaultConfigurationOption<Integer>("client-to-master-port", "Sets the port number where the master accepts connections from clients.", "port", Integer.valueOf(15140), new StringToIntegerFunction(), new PortConstraint());
    public static final String ZIP_STORAGE_LOCATION = "zip-storage-location";
    private final ConfigurationOption<Optional<Path>> zipOutputDir = new GenericTypeConfigurationOption<Optional<Path>>("zip-storage-location", "Sets a directory for zip file results. If no directory is given, no results are stored on the master.", "- | <path>", Optional.absent(), new StringToOptionalFunction<Path>(new StringToPathFunction()), new TypeLiteral<Optional<Path>>(){});
    public static final String REQUIRE_PING_REACHABILITY = "require-ping-reachability";
    private final ConfigurationOption<Boolean> requirePingReachability = new DefaultConfigurationOption<Boolean>("require-ping-reachability", "If set to 'false', the master won't try to ping workers before establishing a connection. This can be helpful when ssh_config allows connecting to a host (e.g. via an additional hop). Defaults to 'true'.", "true | false", true, new StringToBooleanFunction());
    public static final String MAX_RUN_INPUT_FILES = "max-run-input-files";
    private final ConfigurationOption<Integer> maxRunInputFiles = new DefaultConfigurationOption<Integer>("max-run-input-files", "Maximal number of input files for a run. Defaults to 50,000.", "<max number of input files>", Integer.valueOf(50000), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String MAX_RUN_RESULT_FILES = "max-run-result-files";
    private final ConfigurationOption<Integer> maxRunResultFiles = new DefaultConfigurationOption<Integer>("max-run-result-files", "Maximal number of result files for a run. The value is set for all workers started by the master.Defaults to 100,000.", "<max number of result files>", Integer.valueOf(100000), new StringToIntegerFunction(), new PositiveIntegerConstraint());
    public static final String ERROR_TRIGGER_COMMAND = "error-trigger-command";
    private final ConfigurationOption<Optional<String>> errorTriggerCommand = new GenericTypeConfigurationOption<Optional<String>>("error-trigger-command", "Command beeing executed in case of an exception or dead lock.", "- | <command>", Optional.absent(), new StringToOptionalFunction<String>(new StringNotNullFunction()), new TypeLiteral<Optional<String>>(){});
    private final ImmutableSet<ConfigurationOption<?>> options = ImmutableSet.of(this.stdoutLoglevel, this.fileLoglevel, this.fileLogPath, this.compressedFileLogging, this.localPath, this.workerToMasterPort, new ConfigurationOption[]{this.clientToMasterPort, this.zipOutputDir, this.requirePingReachability, this.maxRunInputFiles, this.maxRunResultFiles, this.errorTriggerCommand});

    public Path getLocalPath() {
        return this.localPath.getValue();
    }

    public Level getLogLevel() {
        return this.stdoutLoglevel.getValue();
    }

    public Level getFileLogLevel() {
        return this.fileLoglevel.getValue();
    }

    public Path getFileLogPath() {
        return this.fileLogPath.getValue();
    }

    public boolean isLogFileCompressed() {
        return this.compressedFileLogging.getValue();
    }

    public Optional<String> getErrorTriggerCommand() {
        return this.errorTriggerCommand.getValue();
    }

    public boolean isZipRunResultStoringEnabled() {
        return this.zipOutputDir.getValue().isPresent();
    }

    @Override
    public ImmutableSet<ConfigurationOption<?>> getAllConfigurationOptions() {
        return this.options;
    }

    public static ImmutableSet<ConfigurationOption<?>> getConfigurationOptions() {
        return new MasterConfiguration().getAllConfigurationOptions();
    }

    public static DefaultConfigurationBuilder<MasterConfiguration> getDefaultConfigurationBuilder() {
        return new DefaultConfigurationBuilder<MasterConfiguration>(){

            @Override
            public MasterConfiguration getDefaultConfiguration() {
                return new MasterConfiguration();
            }
        };
    }

    public static String getOptions() {
        return MasterConfiguration.buildOptionsString(MasterConfiguration.getConfigurationOptions());
    }
}

