/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.configuration.workers;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.util.StringBooleanConverter;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class WorkerInformationHandler
implements ConfigurationHandler<Collection<WorkerStartInformation>> {
    private static final Splitter CMD_LINE_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    public static final String WORKER_INFORMATION_CMDLINE_POSSIBLE_OPTIONS = "h1,h2";
    public static final String WORKER_INFORMATION_CMDLINE_OPTION_DESCRIPTION = "Sets the initial set of worker hosts as a comma separated list.";
    public static final String WORKER_INFORMATION_CMDLINE_OPTION_NAME = "hosts";
    Collection<WorkerStartInformation> workerList = Lists.newArrayList();
    private boolean workerCommandlineOptionHasBeenParsed = false;

    @Override
    public void parse(CharSource source, String sourceName) throws ParseException, IOException {
        if (this.workerCommandlineOptionHasBeenParsed) {
            return;
        }
        int lineCounter = 0;
        for (String line : source.readLines()) {
            ++lineCounter;
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            this.workerList.add(this.parseLine(line, lineCounter));
        }
    }

    private WorkerStartInformation parseLine(String nextLine, int lineCounter) throws ParseException {
        String path;
        Iterable<String> tokens = Splitter.on(':').split(nextLine);
        Iterator<String> tokenIt = tokens.iterator();
        if (!tokenIt.hasNext()) {
            throw new ParseException(nextLine, lineCounter);
        }
        WorkerStartInformation.WorkerStartInformationBuilder builder = WorkerStartInformation.WorkerStartInformationBuilder.forHost(tokenIt.next());
        if (tokenIt.hasNext()) {
            Optional<Boolean> usercheck;
            try {
                usercheck = StringBooleanConverter.stringToOptionalBoolean(tokenIt.next());
            }
            catch (InvalidOptionException e) {
                throw new ParseException(nextLine, lineCounter);
            }
            if (usercheck.isPresent()) {
                builder.setUserLoginCheck(usercheck.get());
            }
        }
        if (tokenIt.hasNext() && !(path = tokenIt.next()).isEmpty()) {
            builder.setPath(path);
        }
        if (tokenIt.hasNext()) {
            Optional<Boolean> reverseTunnel;
            try {
                reverseTunnel = StringBooleanConverter.stringToOptionalBoolean(tokenIt.next());
            }
            catch (InvalidOptionException e) {
                throw new ParseException(nextLine, lineCounter);
            }
            if (reverseTunnel.isPresent()) {
                builder.setUseReverseTunnel(reverseTunnel.get());
            }
        }
        return builder.build();
    }

    @Override
    public Collection<WorkerStartInformation> getParseResult() {
        return this.workerList;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, this.workerList);
    }

    @Override
    public void write(OutputStream outputStream, Collection<WorkerStartInformation> workerList) throws IOException {
        if (workerList.size() == 0) {
            String helptext = "# This file contains the description of worker hosts, you may edit it to contain\n# all hosts on which the master ist to start workers via ssh-bootstrapping.\n#\n# One host can be specified on one line, each host must be specified in the following\n# format:\n# hostname:userLoginCheck:path:reverseTunnel\n#\n# Where\n#  - 'hostname' is the hostname on which to start the worker.\n#  - 'userLoginCheck' describes whether the worker is to be stopped if a user other\n#     than the worker logs in. Valid values are either 'on'/'off' or\n#     'enabled'/'disabled'. Giving a value here is optional.\n#  - 'path' is the path of the working directory where files are stored and\n#     runs are executed. This is optional, by default '/tmp' is used.\n#  - 'reverseTunnel' indicates whether the worker should connect via SSH-tunnel\n#     to the master. This option should be used when connecting workers in\n#     unsecure environments (e.g. via the internet). This option allows workers\n#     to connect even if there is no host name resolution or if there are firewalls\n#     blocking the way from the worker host to the master.\n#\n# Empty line and lines starting with '#' are ignored.\n";
            outputStream.write(helptext.getBytes(Charsets.UTF_8));
        }
        for (WorkerStartInformation workerStartInformation : workerList) {
            String line = String.format("%s:%s:%s:%s", workerStartInformation.getHostname(), workerStartInformation.enableUserLoginCheck(), workerStartInformation.getPath(), workerStartInformation.useReverseTunnel());
            outputStream.write(line.getBytes(Charsets.UTF_8));
        }
    }

    @Override
    public CommandLineArguments claimParameters(CommandLineArguments commandlineParameters) throws InvalidOptionException {
        Map<String, String> namedArguments = commandlineParameters.getNamedArguments();
        if (namedArguments.containsKey(WORKER_INFORMATION_CMDLINE_OPTION_NAME)) {
            this.workerList.clear();
            this.workerCommandlineOptionHasBeenParsed = true;
            String hostString = namedArguments.get(WORKER_INFORMATION_CMDLINE_OPTION_NAME);
            Iterable<String> hostIt = CMD_LINE_SPLITTER.split(hostString);
            for (String workerHostname : hostIt) {
                this.workerList.add(WorkerStartInformation.WorkerStartInformationBuilder.forHost(workerHostname).build());
            }
        }
        return commandlineParameters.removeNamedArguments(ImmutableSet.of(WORKER_INFORMATION_CMDLINE_OPTION_NAME));
    }

    public static String getOptions() {
        return "[--hosts h1,h2] ";
    }
}

