/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.files;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.files.ForwardingMasterFileStorage;
import org.sosy_lab.verifiercloud.master.files.MasterFileStorage;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class BufferingMasterFileStorage
implements MasterFileStorage {
    private static final MemoryUnit WARNING_SIZE = MemoryUnit.megabyte(100L);
    private static final Level WARNING_LOG_LEVEL = Level.FINER;
    private final AtomicLong currentSizeInKiloByte = new AtomicLong(0L);
    private final Logger logger;
    private final MasterFileStorage baseMasterFileStorage;
    private final Map<HashCode, FileContent> bufferedFiles = Maps.newConcurrentMap();
    private final ExecutorService fileWriterExecutor;

    BufferingMasterFileStorage(Logger logger, MasterFileStorage underlyingMasterFileStorage) {
        this.baseMasterFileStorage = Preconditions.checkNotNull(underlyingMasterFileStorage);
        this.logger = logger;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getClass().getSimpleName()).build();
        this.fileWriterExecutor = Executors.newSingleThreadExecutor(threadFactory);
    }

    @Inject
    public BufferingMasterFileStorage(Logger logger) {
        this(logger, new ForwardingMasterFileStorage(logger));
    }

    @Override
    public void initializeFileStorage(Path baseWorkingDir) throws IOException {
        this.baseMasterFileStorage.initializeFileStorage(baseWorkingDir);
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        if (this.bufferedFiles.containsKey(fileHash)) {
            return true;
        }
        return this.baseMasterFileStorage.isFileKnown(fileHash);
    }

    @Override
    public HashCode addFile(FileContent fileContent) throws IOException {
        long newSize;
        if (this.bufferedFiles.containsKey(fileContent.getFileHash()) || this.baseMasterFileStorage.isFileKnown(fileContent.getFileHash())) {
            return fileContent.getFileHash();
        }
        this.bufferedFiles.put(fileContent.getFileHash(), fileContent);
        if (this.logger.wouldLog(WARNING_LOG_LEVEL) && (newSize = this.currentSizeInKiloByte.addAndGet(fileContent.getRepresentationSize().toKilobyte())) >= WARNING_SIZE.toKilobyte()) {
            MemoryUnit inMemorySize = MemoryUnit.kilobyte(newSize);
            this.logger.logf(WARNING_LOG_LEVEL, "WARNING: Size of file-buffer in memory is %s in %s files.", inMemorySize, this.bufferedFiles.size());
        }
        this.fileWriterExecutor.execute(new BufferWriter(fileContent));
        return fileContent.getFileHash();
    }

    @Override
    public FileStorageInformation getFileStorageInformation() {
        return this.baseMasterFileStorage.getFileStorageInformation();
    }

    @Override
    public FileContent getFileContent(HashCode fileHash) throws FileNotAvailableException {
        Preconditions.checkNotNull(fileHash);
        FileContent fileContent = this.bufferedFiles.get(fileHash);
        if (fileContent != null) {
            return fileContent;
        }
        return this.baseMasterFileStorage.getFileContent(fileHash);
    }

    private class BufferWriter
    implements Runnable {
        private final FileContent file;

        public BufferWriter(FileContent file) {
            this.file = Preconditions.checkNotNull(file);
        }

        @Override
        public void run() {
            try {
                BufferingMasterFileStorage.this.baseMasterFileStorage.addFile(this.file);
            }
            catch (IOException e) {
                BufferingMasterFileStorage.this.logger.logf(Level.SEVERE, e, "IOException when writing file %s: %s", this.file, e.getMessage());
                return;
            }
            FileContent remove = (FileContent)BufferingMasterFileStorage.this.bufferedFiles.remove(this.file.getFileHash());
            if (remove != null && BufferingMasterFileStorage.this.logger.wouldLog(WARNING_LOG_LEVEL)) {
                long newSize = BufferingMasterFileStorage.this.currentSizeInKiloByte.addAndGet(-this.file.getRepresentationSize().toKilobyte());
                Preconditions.checkState(newSize >= 0L, "New size is %s KB.", newSize);
            }
        }
    }
}

