/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.files;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.file_storage.FileNotAvailableException;
import org.sosy_lab.verifiercloud.global.file_storage.RepresentationFileStorage;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.master.files.MasterFileStorage;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;

public class CachingMasterFileStorage
implements MasterFileStorage {
    private final Logger logger;
    private final RepresentationFileStorage genericFileStorage;
    private final LoadingCache<HashCode, FileContent> fileCache = CacheBuilder.newBuilder().softValues().build(new GetFileContentCallable());

    @Inject
    public CachingMasterFileStorage(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.genericFileStorage = new RepresentationFileStorage(true, logger);
    }

    @Override
    public void initializeFileStorage(Path baseWorkingDir) throws IOException {
        this.genericFileStorage.initializeFileStorage(baseWorkingDir);
        this.genericFileStorage.indexFiles();
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        this.genericFileStorage.checkIsInitialized();
        return this.genericFileStorage.isFileKnown(fileHash);
    }

    @Override
    public HashCode addFile(FileContent fileContent) throws IOException {
        this.genericFileStorage.checkIsInitialized();
        this.fileCache.put(fileContent.getFileHash(), fileContent);
        return this.genericFileStorage.addFile(fileContent);
    }

    @Override
    public FileStorageInformation getFileStorageInformation() {
        return this.genericFileStorage.getFileStorageInformation();
    }

    @Override
    public FileContent getFileContent(HashCode fileHash) throws FileNotAvailableException {
        Preconditions.checkNotNull(fileHash);
        if (!this.genericFileStorage.isFileKnown(fileHash)) {
            throw new FileNotAvailableException(fileHash);
        }
        try {
            return this.fileCache.get(fileHash);
        }
        catch (ExecutionException e) {
            throw new FileNotAvailableException(fileHash, (Throwable)e);
        }
    }

    private final class GetFileContentCallable
    extends CacheLoader<HashCode, FileContent> {
        private GetFileContentCallable() {
        }

        @Override
        public FileContent load(HashCode fileHash) throws Exception {
            Preconditions.checkNotNull(fileHash);
            if (!CachingMasterFileStorage.this.genericFileStorage.isFileKnown(fileHash)) {
                throw new FileNotAvailableException(fileHash);
            }
            Path file = CachingMasterFileStorage.this.genericFileStorage.getFileRepresentationFromStorage(fileHash);
            try {
                return FileUtils.getFileContentFromRepresentation(file, true);
            }
            catch (IllegalArgumentException | CorruptedFileException e) {
                CachingMasterFileStorage.this.logger.logf(Level.SEVERE, e, "File at path %s is coruppted: %s.", file, e.getMessage());
                CachingMasterFileStorage.this.genericFileStorage.removeFile(fileHash);
                throw new FileNotAvailableException(fileHash);
            }
            catch (IOException e) {
                CachingMasterFileStorage.this.logger.logf(Level.SEVERE, e, "IOException when reading file from %s: %s", this.getClass().getSimpleName(), e.getMessage());
                throw new FileNotAvailableException(fileHash);
            }
        }
    }
}

