/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.files;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.files.MasterFileStorage;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;

public class ConcurrentReadMasterFileStorage
implements ConcurrentMasterFileStorage {
    private final MasterFileStorage baseMasterFileStorage;
    private final ListeningExecutorService fileReader;

    public ConcurrentReadMasterFileStorage(MasterFileStorage underlyingMasterFileStorage, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.baseMasterFileStorage = Preconditions.checkNotNull(underlyingMasterFileStorage);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(ConcurrentReadMasterFileStorage.class.getSimpleName() + "-%d").setUncaughtExceptionHandler(uncaughtExceptionHandler);
        ExecutorService simpleExecutor = Executors.newSingleThreadExecutor(tfb.build());
        this.fileReader = MoreExecutors.listeningDecorator(simpleExecutor);
    }

    @Override
    public void initializeFileStorage(Path baseWorkingDir) throws IOException {
        this.baseMasterFileStorage.initializeFileStorage(baseWorkingDir);
    }

    @Override
    public boolean isFileKnown(HashCode fileHash) {
        return this.baseMasterFileStorage.isFileKnown(fileHash);
    }

    @Override
    public HashCode addFile(FileContent fileContent) throws IOException {
        return (HashCode)this.baseMasterFileStorage.addFile(fileContent);
    }

    @Override
    public FileStorageInformation getFileStorageInformation() {
        return this.baseMasterFileStorage.getFileStorageInformation();
    }

    @Override
    public ListenableFuture<FileContent> getFileContent(final HashCode fileHash) {
        return this.fileReader.submit(new Callable<FileContent>(){

            @Override
            public FileContent call() throws Exception {
                return ConcurrentReadMasterFileStorage.this.baseMasterFileStorage.getFileContent(fileHash);
            }
        });
    }
}

