/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.info;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.global.util.time.UptimeMeasurer;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.info.MasterInformationProvider;
import org.sosy_lab.verifiercloud.master.scheduler.Scheduler;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPool;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;

public class DefaultMasterInformationProvider
implements MasterInformationProvider {
    private final UptimeMeasurer uptimeMeasurer = new UptimeMeasurer();
    private final SystemInformationProvider systemInformationProvider;
    private final WorkerPool workerPool;
    private final Scheduler runCollectionScheduler;
    private final ConcurrentMasterFileStorage fileStorage;
    private final Logger logger;

    @Inject
    public DefaultMasterInformationProvider(WorkerPool workerPool, SystemInformationProvider systemInformationProvider, Logger logger, Scheduler runCollectionScheduler, ConcurrentMasterFileStorage fileStorage) {
        this.workerPool = Preconditions.checkNotNull(workerPool);
        this.logger = logger;
        this.runCollectionScheduler = Preconditions.checkNotNull(runCollectionScheduler);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.systemInformationProvider = Preconditions.checkNotNull(systemInformationProvider);
    }

    @Override
    public MasterSummary collectMasterSummary() {
        LoadData loadData;
        int processorCount;
        try {
            processorCount = this.systemInformationProvider.getProcessors().size();
        }
        catch (SystemEnvironmentException e) {
            this.logger.logf(Level.WARNING, e, "Exception when determining processors: %s", e.getMessage());
            processorCount = 0;
        }
        try {
            loadData = this.systemInformationProvider.getLoad();
        }
        catch (SystemEnvironmentException e) {
            this.logger.logf(Level.WARNING, e, "Cannot determine load: %s", e.getMessage());
            loadData = LoadData.invalidLoadData();
        }
        return new MasterSummary(this.uptimeMeasurer.getUptime(), processorCount, loadData, this.workerPool.getWorkerSummaries(), this.workerPool.getAvailableHosts(), this.runCollectionScheduler.getSchedulerSummary(), this.fileStorage.getFileStorageInformation());
    }
}

