/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.networking;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ConnectionAcceptor;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ServerInitializationException;

public class Server {
    private final Logger logger;
    private final int port;
    private Optional<ServerSocket> serverSocket;
    private final ConnectionAcceptor socketReceiver;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public Server(int port, ConnectionAcceptor accept, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        Preconditions.checkArgument(port > 0);
        this.port = port;
        this.socketReceiver = Preconditions.checkNotNull(accept);
        this.serverSocket = Optional.absent();
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
        this.logger = Preconditions.checkNotNull(logger);
    }

    public synchronized boolean isRunning() {
        return this.serverSocket.isPresent() && this.serverSocket.get().isBound() && !this.serverSocket.get().isClosed();
    }

    public synchronized void startServer() throws ServerInitializationException {
        Preconditions.checkState(!this.isRunning());
        try {
            ServerSocket socket = new ServerSocket(this.port);
            this.serverSocket = Optional.of(socket);
        }
        catch (IOException e) {
            this.logger.logf(Level.SEVERE, "Cannot open socket on port %d: %s", this.port, e.getMessage());
            throw new ServerInitializationException("Port cannot be opened.");
        }
        Thread portListener = new Thread((Runnable)new PortListener(this.serverSocket.get()), this.getClass().getSimpleName() + "-port-" + this.port);
        portListener.setUncaughtExceptionHandler(this.exceptionHandler);
        portListener.start();
        this.logger.logf(Level.FINE, "Opened socket on port %d.", this.port);
    }

    public synchronized void stopServer() {
        if (this.serverSocket.isPresent()) {
            try {
                this.serverSocket.get().close();
            }
            catch (IOException e) {
                this.logger.logf(Level.WARNING, e, "Error while closing the server Socket on port %d.", this.port);
            }
        }
    }

    private final class PortListener
    implements Runnable {
        private final ServerSocket serverSocket;

        public PortListener(ServerSocket serverSocket) {
            Preconditions.checkArgument(!serverSocket.isClosed());
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            Preconditions.checkState(!this.serverSocket.isClosed());
            while (!this.serverSocket.isClosed()) {
                Socket clientSocket = null;
                try {
                    clientSocket = this.serverSocket.accept();
                }
                catch (SocketException e) {
                    continue;
                }
                catch (IOException e) {
                    Server.this.logger.logf(Level.WARNING, "Cannot accept client connection.", new Object[0]);
                    return;
                }
                Server.this.logger.logf(Level.FINEST, "Accepted connection from %s on port %d.", clientSocket.getInetAddress(), Server.this.port);
                Server.this.socketReceiver.acceptSocket(clientSocket);
            }
            Server.this.logger.logf(Level.INFO, "Server on port %d stopped. No more incoming connections are accepted.", Server.this.port);
        }
    }
}

