/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.scheduler;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Set;
import org.sosy_lab.verifiercloud.master.scheduler.DefaultScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.scheduler.DefaultScheduler;
import org.sosy_lab.verifiercloud.transportable.run.Run;

class ContainsAssignableRunPredicate
implements Predicate<DefaultScheduledRunCollection> {
    private final DefaultScheduler defaultScheduler;

    ContainsAssignableRunPredicate(DefaultScheduler defaultScheduler) {
        this.defaultScheduler = defaultScheduler;
    }

    @Override
    public boolean apply(DefaultScheduledRunCollection runCollection) {
        if (this.defaultScheduler.futuresOfAssignedRuns.size() < runCollection.getNumberOfUnfinishedRuns()) {
            return true;
        }
        Set<Run> scheduledRuns = this.defaultScheduler.futuresOfAssignedRuns.keySet();
        Set<Run> runsWithoutResult = runCollection.getRunsWithoutResult();
        Sets.SetView<Run> runsNotScheduled = Sets.difference(runsWithoutResult, scheduledRuns);
        return !runsNotScheduled.isEmpty();
    }
}

