/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.scheduler;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.clientside.user.User;
import org.sosy_lab.verifiercloud.master.scheduler.DefaultScheduler;
import org.sosy_lab.verifiercloud.master.scheduler.ScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.scheduler.exceptions.IllegalSecondCallException;
import org.sosy_lab.verifiercloud.master.scheduler.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

final class DefaultScheduledRunCollection
implements ScheduledRunCollection {
    private final DefaultScheduler defaultScheduler;
    private final RunCollection runCollection;
    private final boolean detachable;
    private final User user;
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private volatile SchedulingPriority priority;
    private final long timeCreated;
    private final Map<Run, RunResult> results = Maps.newHashMap();
    private final Set<Run> unfinishedRuns;
    private final Map<Run, SettableFuture<RunResult>> futures = Maps.newHashMap();
    private final ImmutableSet<Run> allRuns;
    private final ScheduledRequirements requirements;
    private final ImmutableSet<Limitations> limitations;
    private volatile TimeInterval consumedWallTime = TimeInterval.seconds(0L);

    DefaultScheduledRunCollection(DefaultScheduler defaultScheduler, List<WorkerSummary> availableWorkers, RunCollection runCollection, boolean detachable, User user, Logger logger) {
        this.defaultScheduler = Preconditions.checkNotNull(defaultScheduler);
        this.runCollection = Preconditions.checkNotNull(runCollection);
        this.detachable = detachable;
        this.user = Preconditions.checkNotNull(user);
        this.unfinishedRuns = Sets.newLinkedHashSet(runCollection.getRuns());
        this.priority = Preconditions.checkNotNull(runCollection.getPriority());
        this.allRuns = ImmutableSet.copyOf(runCollection.getRuns());
        this.timeCreated = System.currentTimeMillis();
        this.requirements = runCollection.getRequirements().toScheduledRequirements(availableWorkers, logger);
        this.limitations = FluentIterable.from(this.allRuns).transform(new ExtractLimitations()).toSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPriority(SchedulingPriority newPriority) {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            Preconditions.checkState(this.priority != null);
            this.priority = Preconditions.checkNotNull(newPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleted() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            boolean allResultsAvailable = this.unfinishedRuns.isEmpty();
            return allResultsAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            return this.canceled.get();
        }
    }

    @Override
    public RunCollection getRunCollection() {
        return this.runCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ListenableFuture<RunResult>> getResults() throws IllegalSecondCallException {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            if (!this.futures.isEmpty()) {
                throw new IllegalSecondCallException("Call this method only once.");
            }
            ImmutableList<Run> runs = this.runCollection.getRuns();
            if (this.canceled.get()) {
                ArrayList<ListenableFuture<RunResult>> resultFutures = Lists.newArrayList();
                String message = this.runCollection + " with name \"" + this.runCollection.getName() + "\" was canceled.";
                for (Run run : runs) {
                    RunCanceledException exception = new RunCanceledException(message, run);
                    ListenableFuture immediateFailedFuture = Futures.immediateFailedFuture(exception);
                    resultFutures.add(immediateFailedFuture);
                }
                return resultFutures;
            }
            ArrayList<ListenableFuture<RunResult>> resultFutures = Lists.newArrayList();
            for (Run run : runs) {
                ListenableFuture<RunResult> futureResult;
                if (this.results.containsKey(run)) {
                    futureResult = Futures.immediateFuture(this.results.get(run));
                } else {
                    SettableFuture<RunResult> settableFuture = SettableFuture.create();
                    this.futures.put(run, settableFuture);
                    futureResult = settableFuture;
                }
                resultFutures.add(futureResult);
            }
            this.results.clear();
            return resultFutures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchedulingPriority getPriority() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            return this.priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRunCollection() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            if (!this.canceled.getAndSet(true) && !this.isCompleted()) {
                this.defaultScheduler.abortRunCollection(this);
                for (Map.Entry<Run, SettableFuture<RunResult>> entry : this.futures.entrySet()) {
                    Run run = entry.getKey();
                    RunCanceledException reason = new RunCanceledException("RunCollection canceled", run);
                    SettableFuture<RunResult> runResult = entry.getValue();
                    runResult.setException(reason);
                }
                this.unfinishedRuns.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResult(RunResult runResult) {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            if (this.canceled.get()) {
                return;
            }
            Run run = runResult.getRun();
            Preconditions.checkArgument(this.allRuns.contains(run), "%s does not contain %s", this.runCollection, run);
            Preconditions.checkArgument(this.unfinishedRuns.contains(run));
            Preconditions.checkArgument(!this.results.containsKey(run), "%s is already set for %s", runResult, this.runCollection);
            this.consumedWallTime = TimeInterval.sum(this.consumedWallTime, runResult.getWallTime());
            this.unfinishedRuns.remove(run);
            if (this.futures.containsKey(run)) {
                this.futures.get(run).set(runResult);
                this.futures.remove(run);
            } else {
                this.results.put(run, runResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunCompleted(Run run) {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            Preconditions.checkNotNull(run);
            Preconditions.checkArgument(this.allRuns.contains(run));
            return !this.unfinishedRuns.contains(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Run> getRunsWithoutResult() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            return Collections.unmodifiableSet(this.unfinishedRuns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfUnfinishedRuns() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            return this.unfinishedRuns.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfFinishedRuns() {
        DefaultScheduler defaultScheduler = this.defaultScheduler;
        synchronized (defaultScheduler) {
            return this.allRuns.size() - this.unfinishedRuns.size();
        }
    }

    @Override
    public User getOwner() {
        return this.user;
    }

    @Override
    public boolean isDetachable() {
        return this.detachable;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public ScheduledRequirements getRequirements() {
        return this.requirements;
    }

    @Override
    public RunCollectionSummary getSummary() {
        return new RunCollectionSummary(this.runCollection.getId(), this.runCollection.getName(), this.runCollection.getRuns().size(), this.getNumberOfFinishedRuns(), this.getOwner().toString(), this.getTimeCreated(), this.consumedWallTime, this.requirements, this.limitations, this.getPriority(), this.detachable);
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public int hashCode() {
        return this.runCollection.hashCode();
    }

    public String toString() {
        return this.runCollection.toString();
    }

    private static final class ExtractLimitations
    implements Function<Run, Limitations> {
        private ExtractLimitations() {
        }

        @Override
        public Limitations apply(@Nonnull Run input) {
            Preconditions.checkNotNull(input);
            return input.getLimitations();
        }
    }
}

