/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.scheduler;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.statistics.StatisticsCollector;
import org.sosy_lab.verifiercloud.master.clientside.user.User;
import org.sosy_lab.verifiercloud.master.scheduler.ContainsAssignableRunPredicate;
import org.sosy_lab.verifiercloud.master.scheduler.DefaultScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.scheduler.FutureIsNotCancelledPredicate;
import org.sosy_lab.verifiercloud.master.scheduler.RunCollectionSummaryFunction;
import org.sosy_lab.verifiercloud.master.scheduler.ScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.scheduler.Scheduler;
import org.sosy_lab.verifiercloud.master.scheduler.SchedulingPrioritizing;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnit;
import org.sosy_lab.verifiercloud.master.workerside.RunExecutionAbortedException;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPool;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPoolListener;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.SchedulerSummary;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class DefaultScheduler
implements Scheduler,
WorkerPoolListener {
    private static final Level LOG_LEVEL_TIMING = Level.FINEST;
    static final int HIGH = 2;
    static final int LOW = 1;
    private static final int MAX_ERROR_CAUSED_RESCHEDULING = 10;
    private final Logger logger;
    private final WorkerPool workerPool;
    private final ListeningExecutorService schedulerExecutor;
    private final AtomicBoolean unfinishedScheduling = new AtomicBoolean(false);
    private final Map<Run, DefaultScheduledRunCollection> runToScheduledRunCollectionMap = Maps.newHashMap();
    private final Multimap<User, DefaultScheduledRunCollection> userToScheduledRunCollectionsMap = HashMultimap.create();
    final Map<Run, CheckedFuture<RunResult, RunExecutionAbortedException>> futuresOfAssignedRuns = Maps.newHashMap();
    private final Map<Run, Integer> errorCausedRunExecutionAbortCounter = Maps.newHashMap();
    private final List<DefaultScheduledRunCollection> history = Lists.newLinkedList();
    private volatile int numberOfFinishedRuns = 0;
    private volatile TimeInterval timeConsumedByFinishedRuns = TimeInterval.zero();
    private volatile TimeInterval accumulatedRunWaitingTime = TimeInterval.zero();
    private static final String NUMBER_OF_FINSHED_RUNS = "Number of finished runs";
    private static final String TIME_CONSUMED_BY_FINISHED_RUNS = "Time consumed by finished runs";
    private static final String NUMBER_OF_FINISHED_RUNCOLLECTIONS = "Number of finshed run collections";
    private final StatisticsCollector statisticsCollector;
    private final Object schedulingSynchronization;

    @Inject
    public DefaultScheduler(WorkerPool workerPool, StatisticsCollector statisticsCollector, @Named(value="error-trigger") Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.workerPool = Preconditions.checkNotNull(workerPool);
        this.statisticsCollector = Preconditions.checkNotNull(statisticsCollector);
        ThreadFactory schedulerThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getClass().getSimpleName() + "-%d").setUncaughtExceptionHandler(exceptionHandler).build();
        this.schedulerExecutor = MoreExecutors.listeningDecorator(Executors.newSingleThreadExecutor(schedulerThreadFactory));
        this.schedulingSynchronization = this;
    }

    private void initiateScheduling() {
        if (!this.unfinishedScheduling.getAndSet(true)) {
            this.schedulerExecutor.submit(new SchedulingRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfAssignedRuns() {
        Object object = this.schedulingSynchronization;
        synchronized (object) {
            return FluentIterable.from(this.futuresOfAssignedRuns.values()).filter(new FutureIsNotCancelledPredicate()).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfUnassignedRuns() {
        Object object = this.schedulingSynchronization;
        synchronized (object) {
            int unfinishedRuns = 0;
            for (DefaultScheduledRunCollection runCollection : this.getScheduledRunCollections()) {
                int unfinishedRunsInCollection = runCollection.getNumberOfUnfinishedRuns();
                Preconditions.checkState(unfinishedRunsInCollection >= 0, "Unfinished runs in %s is %s", runCollection, unfinishedRunsInCollection);
                unfinishedRuns += unfinishedRunsInCollection;
            }
            Preconditions.checkState(unfinishedRuns >= 0, "%s unfinished runs", unfinishedRuns);
            int assignedRuns = this.getNumberOfAssignedRuns();
            int unassignedRuns = unfinishedRuns - assignedRuns;
            Preconditions.checkState(unassignedRuns >= 0, "%s unassigned runs with %s unfinished runs and %s assigned runs.", unassignedRuns, unfinishedRuns, assignedRuns);
            return unassignedRuns;
        }
    }

    private Collection<DefaultScheduledRunCollection> getScheduledRunCollections() {
        return Collections.unmodifiableCollection(this.userToScheduledRunCollectionsMap.values());
    }

    private void assignAndSendRun(ProcessingUnit processingUnit, final Run run) {
        CheckedFuture<RunResult, RunExecutionAbortedException> futureResult;
        CheckedFuture<RunResult, RunExecutionAbortedException> previous;
        final DefaultScheduledRunCollection scheduledRunCollection = this.runToScheduledRunCollectionMap.get(run);
        ScheduledRequirements requirements = scheduledRunCollection.getRequirements();
        Preconditions.checkArgument(processingUnit.currentlySatisfiesRequirements(requirements), "Sending run %s of run collection %s to %s, but requirements %s are not satisfied.", run, scheduledRunCollection, MoreStrings.longStringOf(processingUnit), requirements);
        this.history.add(scheduledRunCollection);
        int numberOfUsers = this.userToScheduledRunCollectionsMap.keySet().size();
        int maxHistorySize = 4 * numberOfUsers;
        if (this.history.size() > maxHistorySize) {
            this.history.remove(0);
        }
        Preconditions.checkState((previous = this.futuresOfAssignedRuns.put(run, futureResult = processingUnit.execute(run, scheduledRunCollection))) == null);
        Futures.addCallback(futureResult, new FutureCallback<RunResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(RunResult result) {
                Object object = DefaultScheduler.this.schedulingSynchronization;
                synchronized (object) {
                    Preconditions.checkArgument(result.getRun().equals(run));
                    DefaultScheduler.this.setRunResult(run, result);
                    CheckedFuture<RunResult, RunExecutionAbortedException> remove = DefaultScheduler.this.futuresOfAssignedRuns.remove(run);
                    Preconditions.checkState(remove != null);
                    Preconditions.checkState(DefaultScheduler.this.getNumberOfUnassignedRuns() >= 0);
                    ++DefaultScheduler.this.numberOfFinishedRuns;
                    DefaultScheduler.this.timeConsumedByFinishedRuns = TimeInterval.sum(DefaultScheduler.this.timeConsumedByFinishedRuns, result.getWallTime());
                    TimeInterval timeSinceCreattion = TimeInterval.milliseconds(System.currentTimeMillis() - scheduledRunCollection.getTimeCreated());
                    DefaultScheduler.this.accumulatedRunWaitingTime = TimeInterval.sum(DefaultScheduler.this.accumulatedRunWaitingTime, timeSinceCreattion);
                }
                DefaultScheduler.this.statisticsCollector.set(DefaultScheduler.TIME_CONSUMED_BY_FINISHED_RUNS, DefaultScheduler.this.timeConsumedByFinishedRuns);
                DefaultScheduler.this.statisticsCollector.increment(DefaultScheduler.NUMBER_OF_FINSHED_RUNS);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable t) {
                Object object = DefaultScheduler.this.schedulingSynchronization;
                synchronized (object) {
                    CheckedFuture<RunResult, RunExecutionAbortedException> remove = DefaultScheduler.this.futuresOfAssignedRuns.remove(run);
                    Preconditions.checkState(remove != null);
                    if (t instanceof RunExecutionAbortedException && ((RunExecutionAbortedException)t).isErrorCaused() && DefaultScheduler.this.runToScheduledRunCollectionMap.containsKey(run)) {
                        this.handleErrorCausedRunExecutionAbort(run);
                    }
                    DefaultScheduler.this.logger.logf(Level.INFO, "Rescheduling of %s, caused by: %s", run, t.getMessage());
                    Preconditions.checkState(!DefaultScheduler.this.futuresOfAssignedRuns.containsKey(run));
                    DefaultScheduler.this.initiateScheduling();
                }
            }

            private void handleErrorCausedRunExecutionAbort(Run run2) {
                if (DefaultScheduler.this.errorCausedRunExecutionAbortCounter.containsKey(run2)) {
                    int current = (Integer)DefaultScheduler.this.errorCausedRunExecutionAbortCounter.get(run2);
                    if (current < 10) {
                        int newCount = current + 1;
                        DefaultScheduler.this.errorCausedRunExecutionAbortCounter.put(run2, newCount);
                    } else {
                        DefaultScheduler.this.logger.logf(Level.SEVERE, "Execution of %s failed %s times.", run2, 10);
                        ((DefaultScheduledRunCollection)DefaultScheduler.this.runToScheduledRunCollectionMap.get(run2)).cancelRunCollection();
                    }
                } else {
                    DefaultScheduler.this.errorCausedRunExecutionAbortCounter.put(run2, 1);
                }
            }
        }, this.schedulerExecutor);
        this.logger.logf(Level.INFO, "Assigned %s (belonging to %s from %s) to %s.", run, scheduledRunCollection.getOwner(), scheduledRunCollection, processingUnit);
    }

    @Override
    public void processingUnitAvailable() {
        this.initiateScheduling();
    }

    @Override
    public void processingUnitUnavailable(ProcessingUnit processingUnit) {
    }

    @Override
    public void processingUnitStateChanged(ProcessingUnit processingUnit, boolean changeFreedCapacity) {
        if (processingUnit.isUsable() && changeFreedCapacity && processingUnit.hasFreeCapacity()) {
            this.initiateScheduling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunResult(Run run, RunResult runResult) {
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(runResult);
        Preconditions.checkArgument(runResult.getRun().equals(run));
        Object object = this.schedulingSynchronization;
        synchronized (object) {
            if (this.runToScheduledRunCollectionMap.containsKey(run)) {
                DefaultScheduledRunCollection scheduledRunCollection = this.runToScheduledRunCollectionMap.get(run);
                scheduledRunCollection.setResult(runResult);
                this.runToScheduledRunCollectionMap.remove(run);
                if (scheduledRunCollection.isCompleted()) {
                    this.userToScheduledRunCollectionsMap.remove(scheduledRunCollection.getOwner(), scheduledRunCollection);
                    this.history.remove(scheduledRunCollection);
                    this.statisticsCollector.increment(NUMBER_OF_FINISHED_RUNCOLLECTIONS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledRunCollection addRunCollection(RunCollection runCollection, User user, boolean detachable) {
        Preconditions.checkNotNull(runCollection);
        Preconditions.checkNotNull(user);
        Object object = this.schedulingSynchronization;
        synchronized (object) {
            DefaultScheduledRunCollection scheduledRunCollection = new DefaultScheduledRunCollection(this, this.workerPool.getWorkerSummaries(), runCollection, detachable, user, this.logger);
            for (Run run : runCollection.getRuns()) {
                this.runToScheduledRunCollectionMap.put(run, scheduledRunCollection);
            }
            this.userToScheduledRunCollectionsMap.put(user, scheduledRunCollection);
            Preconditions.checkState(this.getNumberOfUnassignedRuns() >= 0);
            this.initiateScheduling();
            return scheduledRunCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortRunCollection(DefaultScheduledRunCollection runCollection) {
        Object object = this.schedulingSynchronization;
        synchronized (object) {
            Preconditions.checkArgument(runCollection.isCanceled());
            Preconditions.checkArgument(this.runToScheduledRunCollectionMap.containsValue(runCollection), "%s is not known.", runCollection);
            if (runCollection.isCompleted()) {
                return;
            }
            ImmutableList<Run> runs = runCollection.getRunCollection().getRuns();
            for (Run run : runs) {
                this.runToScheduledRunCollectionMap.remove(run);
                if (!this.futuresOfAssignedRuns.containsKey(run)) continue;
                this.futuresOfAssignedRuns.get(run).cancel(true);
            }
            this.userToScheduledRunCollectionsMap.remove(runCollection.getOwner(), runCollection);
            Preconditions.checkState(this.getNumberOfUnassignedRuns() >= 0);
        }
        this.logger.logf(Level.INFO, "%s was aborted.", runCollection.getRunCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchedulerSummary getSchedulerSummary() {
        Object object = this.schedulingSynchronization;
        synchronized (object) {
            ImmutableList<RunCollectionSummary> summaries = FluentIterable.from(this.getScheduledRunCollections()).transform(RunCollectionSummaryFunction.INSTANCE).toList();
            return new SchedulerSummary(summaries, this.getNumberOfAssignedRuns(), this.getNumberOfUnassignedRuns(), this.numberOfFinishedRuns, this.timeConsumedByFinishedRuns, this.accumulatedRunWaitingTime);
        }
    }

    private class SchedulingRunnable
    implements Runnable {
        private long timeForOrderingNanos = 0L;
        private Optional<List<DefaultScheduledRunCollection>> validCollectionOrder = Optional.absent();

        private SchedulingRunnable() {
        }

        @Override
        public void run() {
            try {
                this.executeScheduling();
            }
            catch (Throwable t) {
                DefaultScheduler.this.logger.logf(Level.SEVERE, t, "Exception during scheduling", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeScheduling() {
            Object object = DefaultScheduler.this.schedulingSynchronization;
            synchronized (object) {
                long schedulinStartTimeNanos = 0L;
                long overallAssignmentTimeNanos = 0L;
                int assignedRuns = 0;
                if (DefaultScheduler.this.logger.wouldLog(LOG_LEVEL_TIMING)) {
                    schedulinStartTimeNanos = System.nanoTime();
                    DefaultScheduler.this.logger.logf(LOG_LEVEL_TIMING, "Starting scheduling.", new Object[0]);
                }
                DefaultScheduler.this.unfinishedScheduling.set(false);
                if (!DefaultScheduler.this.userToScheduledRunCollectionsMap.isEmpty()) {
                    ImmutableList<ProcessingUnit> processingUnits = DefaultScheduler.this.workerPool.getProcessingUnitsWithFreeCapacity();
                    for (ProcessingUnit procUnit : processingUnits) {
                        Optional<Run> run = this.selectRunForProcessingUnit(procUnit);
                        while (run.isPresent()) {
                            long runAssignmentTime = 0L;
                            if (DefaultScheduler.this.logger.wouldLog(LOG_LEVEL_TIMING)) {
                                runAssignmentTime = System.nanoTime();
                            }
                            DefaultScheduler.this.assignAndSendRun(procUnit, run.get());
                            ++assignedRuns;
                            if (DefaultScheduler.this.logger.wouldLog(LOG_LEVEL_TIMING)) {
                                overallAssignmentTimeNanos += System.nanoTime() - runAssignmentTime;
                            }
                            run = this.selectRunForProcessingUnit(procUnit);
                        }
                    }
                }
                if (DefaultScheduler.this.logger.wouldLog(LOG_LEVEL_TIMING)) {
                    long endTimeNanos = System.nanoTime();
                    long overallTimeNanos = endTimeNanos - schedulinStartTimeNanos;
                    DefaultScheduler.this.logger.logf(LOG_LEVEL_TIMING, "Finished scheduling after %s ns, assigned %s runs (%s%% for assignments, %s%% for ordering).", overallTimeNanos, assignedRuns, 100L * overallAssignmentTimeNanos / overallTimeNanos, 100L * this.timeForOrderingNanos / overallTimeNanos);
                }
            }
        }

        private Optional<Run> selectRunForProcessingUnit(ProcessingUnit processingUnit) {
            if (!this.validCollectionOrder.isPresent()) {
                FluentIterable<DefaultScheduledRunCollection> assignableRunCollections = FluentIterable.from(DefaultScheduler.this.getScheduledRunCollections()).filter(new ContainsAssignableRunPredicate(DefaultScheduler.this));
                long timeBeforeNanos = 0L;
                if (DefaultScheduler.this.logger.wouldLog(LOG_LEVEL_TIMING)) {
                    timeBeforeNanos = System.nanoTime();
                }
                List<DefaultScheduledRunCollection> prioritizedRunCollections = SchedulingPrioritizing.prioritizeRunCollections(DefaultScheduler.this.history, DefaultScheduler.this.userToScheduledRunCollectionsMap.keySet(), assignableRunCollections);
                if (DefaultScheduler.this.logger.wouldLog(LOG_LEVEL_TIMING)) {
                    long timeAfterNanos = System.nanoTime();
                    long timeDifference = timeAfterNanos - timeBeforeNanos;
                    this.timeForOrderingNanos += timeDifference;
                }
                this.validCollectionOrder = Optional.of(prioritizedRunCollections);
            }
            for (DefaultScheduledRunCollection runCollection : this.validCollectionOrder.get()) {
                Set<Run> assignedRuns;
                ScheduledRequirements runCollectionRequirements = runCollection.getRequirements();
                if (!processingUnit.currentlySatisfiesRequirements(runCollectionRequirements)) continue;
                Set<Run> runsWithoutResult = runCollection.getRunsWithoutResult();
                Sets.SetView<Run> assignableRuns = Sets.difference(runsWithoutResult, assignedRuns = DefaultScheduler.this.futuresOfAssignedRuns.keySet());
                Optional<Run> nextRun = FluentIterable.from(assignableRuns).first();
                if (nextRun.isPresent()) {
                    this.validCollectionOrder = Optional.absent();
                }
                return nextRun;
            }
            return Optional.absent();
        }
    }
}

