/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.verifiercloud.master.clientside.user.DummyUser;
import org.sosy_lab.verifiercloud.master.clientside.user.User;
import org.sosy_lab.verifiercloud.master.scheduler.ScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.scheduler.exceptions.IllegalSecondCallException;
import org.sosy_lab.verifiercloud.transportable.collections.DefaultRunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.filecontent.DefaultFileContent;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.DummyHostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunBuilder;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public abstract class ScheduledRunCollectionTestBase {
    @Test
    public void testCancel() {
        ScheduledRunCollection rc = this.getScheduledRunCollection();
        rc.cancelRunCollection();
        Assert.assertTrue((boolean)rc.isCanceled());
    }

    @Test
    public void testNotCanceled() {
        ScheduledRunCollection rc = this.getScheduledRunCollection();
        Assert.assertFalse((boolean)rc.isCanceled());
    }

    @Test
    public void testSetPriority() {
        ScheduledRunCollection rc = this.getScheduledRunCollection();
        SchedulingPriority newPriority = SchedulingPriority.URGENT;
        rc.setPriority(newPriority);
        Assert.assertEquals((Object)((Object)rc.getPriority()), (Object)((Object)newPriority));
    }

    @Test
    public void testGetInitialPriority() {
        ScheduledRunCollection rc = this.getScheduledRunCollection();
        Assert.assertFalse((rc.getPriority() == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetOwner() {
        User user = this.getUser();
        RunCollection runCollection = this.createRunCollectionWithNewRuns(6);
        this.getScheduledRunCollection(runCollection, user);
        User differentUser = this.getUser();
        RunCollection differentRunCollection = this.createRunCollectionWithNewRuns(1);
        ScheduledRunCollection scheduledRunCollection = this.getScheduledRunCollection(differentRunCollection, differentUser);
        User returnedUser = scheduledRunCollection.getOwner();
        Assert.assertEquals((Object)differentUser, (Object)returnedUser);
    }

    @Test(expected=IllegalSecondCallException.class)
    public void testIllegalSecondCallException() {
        User user = this.getUser();
        RunCollection runCollection = this.createRunCollectionWithNewRuns(6);
        ScheduledRunCollection c = this.getScheduledRunCollection(runCollection, user);
        c.getResults();
        c.getResults();
    }

    private ScheduledRunCollection getScheduledRunCollection() {
        return this.getScheduledRunCollection(this.createRunCollectionWithNewRuns(1), this.getUser());
    }

    protected RunCollection createRunCollectionWithNewRuns(int numberOfRuns) {
        Preconditions.checkArgument(numberOfRuns > 0);
        ArrayList<Run> runs = Lists.newArrayList();
        for (int i = 0; i < numberOfRuns; ++i) {
            Run newRun = RunBuilder.forCommand(Lists.newArrayList("command")).build();
            runs.add(newRun);
        }
        return DefaultRunCollection.forRuns(runs).build();
    }

    protected User getUser() {
        return new DummyUser();
    }

    protected RunResult getRunResult(Run run) {
        return new RunResult(run, 0, TimeInterval.seconds(1L), TimeInterval.hours(0L), ImmutableMap.of(), DefaultFileContent.fromBytes(new byte[0]), Lists.newArrayList(), new DummyHostInformation());
    }

    protected abstract ScheduledRunCollection getScheduledRunCollection(RunCollection var1, User var2);
}

