/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.verifiercloud.master.clientside.user.User;
import org.sosy_lab.verifiercloud.master.scheduler.ExtractUserFromScheduledRunCollectionFunction;
import org.sosy_lab.verifiercloud.master.scheduler.PriorityMatcher;
import org.sosy_lab.verifiercloud.master.scheduler.ScheduledRunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;

public final class SchedulingPrioritizing {
    private SchedulingPrioritizing() {
    }

    public static <T extends ScheduledRunCollection> List<T> prioritizeRunCollections(List<T> history, Set<User> users, Iterable<T> assignableRunCollections) {
        if (FluentIterable.from(assignableRunCollections).size() < 2) {
            return ImmutableList.copyOf(assignableRunCollections);
        }
        ArrayList<ScheduledRunCollection> result = Lists.newArrayList();
        ArrayList<ScheduledRunCollection> highRC = Lists.newArrayList();
        for (SchedulingPriority priority : SchedulingPriority.values()) {
            List<ScheduledRunCollection> interleavedRC;
            ImmutableList<ScheduledRunCollection> runCollections = FluentIterable.from(assignableRunCollections).filter(new PriorityMatcher(priority)).toList();
            switch (priority) {
                case URGENT: 
                case IDLE: {
                    interleavedRC = SchedulingPrioritizing.simpleInterleave(runCollections, history, users);
                    break;
                }
                case HIGH: {
                    highRC.addAll(runCollections);
                    interleavedRC = Lists.newArrayList();
                    break;
                }
                case LOW: {
                    interleavedRC = SchedulingPrioritizing.twoPriorityInterleave(runCollections, highRC, history, users);
                    break;
                }
                default: {
                    throw new RuntimeException("Unimplemented priority: " + (Object)((Object)priority));
                }
            }
            result.addAll(interleavedRC);
        }
        return result;
    }

    private static <T extends ScheduledRunCollection> List<T> twoPriorityInterleave(List<T> lowerPriority, List<T> higherPriority, List<T> history, Set<User> users) {
        if (lowerPriority.isEmpty()) {
            return SchedulingPrioritizing.simpleInterleave(higherPriority, history, users);
        }
        if (higherPriority.isEmpty()) {
            return SchedulingPrioritizing.simpleInterleave(lowerPriority, history, users);
        }
        LinkedList priorityOrderedRC = Lists.newLinkedList();
        FluentIterable.from(Iterables.concat(higherPriority, lowerPriority)).filter(Predicates.not(Predicates.in(history))).copyInto(priorityOrderedRC);
        FluentIterable.from(history).filter(Predicates.or(Predicates.in(higherPriority), Predicates.in(lowerPriority))).copyInto(priorityOrderedRC);
        HashMap<User, Integer> userRate = Maps.newHashMap();
        for (User user : users) {
            boolean highPriority = false;
            for (ScheduledRunCollection rc : higherPriority) {
                if (!rc.getOwner().equals(user)) continue;
                highPriority = true;
                break;
            }
            if (highPriority) {
                userRate.put(user, 2);
                continue;
            }
            userRate.put(user, 1);
        }
        LinkedList<User> orderedUsers = Lists.newLinkedList();
        for (ScheduledRunCollection runCollection : history) {
            User user = runCollection.getOwner();
            orderedUsers.add(user);
            if (userRate.containsKey(user)) {
                int oldValue = (Integer)userRate.remove(user);
                if (oldValue <= 1) continue;
                userRate.put(user, oldValue - 1);
                continue;
            }
            orderedUsers.remove(user);
        }
        if (!userRate.isEmpty()) {
            int maxUserRate;
            LinkedList<User> remainingorderedUsers = Lists.newLinkedList();
            for (int i = maxUserRate = ((Integer)Collections.max(userRate.values())).intValue(); i > 0; --i) {
                for (Map.Entry entry : userRate.entrySet()) {
                    int rate = (Integer)entry.getValue();
                    if (rate != i) continue;
                    User user = (User)entry.getKey();
                    remainingorderedUsers.add(user);
                    userRate.put(user, rate - 1);
                }
            }
            orderedUsers.addAll(0, remainingorderedUsers);
        }
        List result = SchedulingPrioritizing.userInterleave(priorityOrderedRC, orderedUsers);
        return result;
    }

    private static <T extends ScheduledRunCollection> List<T> simpleInterleave(List<T> runCollections, List<T> history, Set<User> users) {
        if (runCollections.size() < 2) {
            return runCollections;
        }
        LinkedList priorityOrderedRC = Lists.newLinkedList();
        FluentIterable.from(runCollections).filter(Predicates.not(Predicates.in(history))).copyInto(priorityOrderedRC);
        FluentIterable.from(history).filter(Predicates.in(runCollections)).copyInto(priorityOrderedRC);
        List<User> orderedUsers = SchedulingPrioritizing.getOrderedUsers(Lists.transform(history, ExtractUserFromScheduledRunCollectionFunction.INSTANCE), users);
        return SchedulingPrioritizing.userInterleave(priorityOrderedRC, orderedUsers);
    }

    private static <T extends ScheduledRunCollection> List<T> userInterleave(LinkedList<T> priorityOrderedRC, List<User> priorityOrderedUsers) {
        Preconditions.checkArgument(!priorityOrderedUsers.isEmpty());
        HashSet<ScheduledRunCollection> alreadyAddedRCs = Sets.newHashSet();
        Iterator usersIt = FluentIterable.from(priorityOrderedUsers).cycle().iterator();
        Preconditions.checkState(usersIt.hasNext());
        ArrayList<ScheduledRunCollection> result = Lists.newArrayList();
        while (!priorityOrderedRC.isEmpty()) {
            boolean foundRCForUser = false;
            User user = (User)usersIt.next();
            Iterator runCollectionIt = priorityOrderedRC.iterator();
            while (runCollectionIt.hasNext() && !foundRCForUser) {
                ScheduledRunCollection runCollection = (ScheduledRunCollection)runCollectionIt.next();
                if (alreadyAddedRCs.contains(runCollection)) {
                    alreadyAddedRCs.add(runCollection);
                    runCollectionIt.remove();
                    continue;
                }
                if (!user.equals(runCollection.getOwner())) continue;
                foundRCForUser = true;
                result.add(runCollection);
                runCollectionIt.remove();
                alreadyAddedRCs.add(runCollection);
            }
        }
        return result;
    }

    static List<User> getOrderedUsers(List<User> userHistory, Set<User> usersWithScheduledRunCollection) {
        LinkedList<User> orderedUsers = Lists.newLinkedList();
        orderedUsers.addAll(usersWithScheduledRunCollection);
        for (User user : userHistory) {
            orderedUsers.remove(user);
            orderedUsers.add(user);
        }
        return orderedUsers;
    }
}

