/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.scheduler.ScheduledRunCollection;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnit;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnitSnapshot;
import org.sosy_lab.verifiercloud.master.workerside.RunExecutionAbortedException;
import org.sosy_lab.verifiercloud.master.workerside.WorkerAbstraction;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.EnoughAvailablMemoryOnNodes;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.EnoughAvailablProcessorsOnNodes;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessorsToSocketToNumOfProcessor;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.SetSizeComparator;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.AssignRunCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.CancelRunCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.FinishRunCommand;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.processors.CoreComparator;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.processors.ProcessorToSocketIdFunction;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class DefaultProcessingUnit
implements ProcessingUnit {
    private final Logger logger;
    private final WorkerAbstraction worker;
    private final Map<Run, RunFuture> assignedRuns = Maps.newConcurrentMap();
    private final Multimap<Run, Processor> processorMappings;
    private final Map<Run, Map<Integer, MemoryUnit>> memoryMapping;
    private final Object processingUnitSynchronization;
    private volatile Optional<ImmutableSet<Processor>> currentlyUnreservedProcessors = Optional.absent();

    DefaultProcessingUnit(WorkerAbstraction workerAbstraction, Logger logger) {
        this.worker = Preconditions.checkNotNull(workerAbstraction);
        this.logger = Preconditions.checkNotNull(logger);
        this.memoryMapping = Maps.newHashMap();
        ArrayListMultimap processorMappings = ArrayListMultimap.create();
        this.processorMappings = MapConstraints.constrainedMultimap(processorMappings, new MapConstraint<Run, Processor>(){

            @Override
            public void checkKeyValue(Run key, Processor value) {
                Preconditions.checkNotNull(value);
                if (!DefaultProcessingUnit.this.getAvailableProcessors().contains(value)) {
                    throw new RuntimeException("Processor " + value + " is not a valid processor for " + DefaultProcessingUnit.this.worker);
                }
            }
        });
        this.processingUnitSynchronization = workerAbstraction;
    }

    private ImmutableSet<Processor> getAvailableProcessors() {
        ImmutableSet<Processor> allProcessors = this.worker.getHostInformation().getProcessors();
        ImmutableSet<Processor> unusableProcessors = this.worker.getRuntimeInformation().getUnusableProcessors();
        if (unusableProcessors.isEmpty()) {
            return allProcessors;
        }
        return FluentIterable.from(allProcessors).filter(Predicates.not(Predicates.in(unusableProcessors))).toSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean currentlySatisfiesRequirements(ScheduledRequirements requirements) {
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            if (!this.isUsable()) {
                return false;
            }
            MemoryUnit unreservedMemory = this.getUnreservedMemory();
            ImmutableSet<Processor> unreservedCores = this.getUnreservedCores();
            if (unreservedMemory.isZero() || this.getUnreservedCoreCount() == 0) {
                return false;
            }
            HostInformation hostInformation = this.worker.getHostInformation();
            return requirements.isSatisfiedBy(unreservedMemory, this.getUnreservedNumaMemory(), unreservedCores, this.worker.getMaxUsableCoreCountPerSocket(), hostInformation);
        }
    }

    @Override
    public MemoryUnit getUnreservedMemory() {
        MemoryUnit unreserved;
        MemoryUnit workerMemory = this.worker.getHostInformation().getTotalMemory();
        MemoryUnit currentlyFreeMemory = this.worker.getRuntimeInformation().getFreeMemory();
        MemoryUnit usable = this.worker.getRuntimeInformation().getUsableMemory();
        MemoryUnit unusable = workerMemory.minus(usable);
        MemoryUnit reserved = this.getReservedMemory();
        MemoryUnit allButUnreserved = MemoryUnit.sum(Constants.SYSTEM_MEMORY, reserved, unusable);
        try {
            unreserved = workerMemory.minus(allButUnreserved);
        }
        catch (ArithmeticException e) {
            throw new IllegalStateException(String.format("Invalid memory information on worker %s with %s partitions with memory allocations [%s] (allButUnreserved > total): total=%s, free=%s, usable=%s, reserved=%s, allButUnreserved=%s", this.worker.getHostInformation().getHostname(), this.assignedRuns.size(), Joiner.on(", ").join(this.memoryMapping.values()), workerMemory, currentlyFreeMemory, usable, reserved, allButUnreserved), e);
        }
        return MemoryUnit.min(unreserved, currentlyFreeMemory);
    }

    public Map<Integer, MemoryUnit> getUnreservedNumaMemory() {
        ImmutableMap.Builder<Integer, MemoryUnit> result = ImmutableMap.builder();
        Map<Integer, MemoryUnit> workerMemory = this.worker.getHostInformation().getTotalNumaMemory();
        Map<Integer, MemoryUnit> currentlyFreeMemory = this.worker.getRuntimeInformation().getFreeNumaMemory();
        for (int nodeID : workerMemory.keySet()) {
            long reservedMemoryBytes = 0L;
            for (Map<Integer, MemoryUnit> reservedMemoryPerNode : this.memoryMapping.values()) {
                if (!reservedMemoryPerNode.containsKey(nodeID)) continue;
                reservedMemoryBytes += reservedMemoryPerNode.get(nodeID).toByte();
            }
            MemoryUnit reservedMemory = MemoryUnit.bytes(reservedMemoryBytes);
            MemoryUnit notReserved = workerMemory.get(nodeID).minus(reservedMemory);
            MemoryUnit unreserved = MemoryUnit.min(currentlyFreeMemory.get(nodeID), notReserved);
            result.put(nodeID, unreserved);
        }
        return result.build();
    }

    @Override
    public MemoryUnit getReservedMemory() {
        long reservedMemoryBytes = 0L;
        for (Map<Integer, MemoryUnit> runMemoryLimit : this.memoryMapping.values()) {
            reservedMemoryBytes += MemoryUnit.sum(runMemoryLimit.values()).toByte();
        }
        return MemoryUnit.bytes(reservedMemoryBytes);
    }

    @Override
    public int getNumberOfReservedProcessors() {
        return this.processorMappings.values().size();
    }

    private int getUnreservedCoreCount() {
        return this.getUnreservedCores().size();
    }

    static ImmutableSet<Processor> calculateUnreservedCores(ImmutableSet<Processor> allProcessors, Set<Processor> assignedProcessors) {
        if (assignedProcessors.isEmpty()) {
            return allProcessors;
        }
        if (assignedProcessors.equals(allProcessors)) {
            return ImmutableSet.of();
        }
        ArrayListMultimap<Integer, Processor> distinctCoreMap = ArrayListMultimap.create();
        for (Processor processor : allProcessors) {
            int key = DefaultProcessingUnit.hashForPhysicalDistinctCore(processor);
            distinctCoreMap.put(key, processor);
        }
        HashSet blockedProcessors = Sets.newHashSet();
        for (Processor processor : assignedProcessors) {
            int key = DefaultProcessingUnit.hashForPhysicalDistinctCore(processor);
            blockedProcessors.addAll(distinctCoreMap.get(key));
        }
        return ImmutableSet.copyOf(Sets.difference(allProcessors, blockedProcessors));
    }

    private static int hashForPhysicalDistinctCore(Processor processor) {
        return (processor.getCoreId() << 16) + processor.getSocketId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableSet<Processor> getUnreservedCores() {
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            if (!this.currentlyUnreservedProcessors.isPresent()) {
                this.currentlyUnreservedProcessors = Optional.of(DefaultProcessingUnit.calculateUnreservedCores(this.getAvailableProcessors(), ImmutableSet.copyOf(this.processorMappings.values())));
            }
            return this.currentlyUnreservedProcessors.get();
        }
    }

    @Override
    public boolean canSatisfyRequirements(Requirements requirements) {
        return this.worker.canSatisfyRequirements(requirements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFreeCapacity() {
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            return this.isUsable() && this.getUnreservedCoreCount() > 0 && !this.getUnreservedMemory().isZero();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsable() {
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            ExternalWorkerState workerState = this.worker.getState();
            if (!this.worker.getHostInformation().isCgroupsAvailable()) {
                return false;
            }
            return workerState == ExternalWorkerState.AVAILABLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedFuture<RunResult, RunExecutionAbortedException> execute(Run run, ScheduledRunCollection runCollection) {
        ScheduledRequirements requirements = runCollection.getRequirements();
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            Preconditions.checkArgument(this.currentlySatisfiesRequirements(requirements), "Assigning run %s of run collection %s to %s, which currently does not fulfill the requirements %s.", run, runCollection, MoreStrings.longStringOf(this), requirements);
            ImmutableSet<Processor> selectedProcessors = this.selectProcessors(run, requirements);
            this.processorMappings.putAll(run, selectedProcessors);
            this.currentlyUnreservedProcessors = Optional.absent();
            Map<Integer, MemoryUnit> memoryLimit = this.selectMemoryLimitForRun(run, selectedProcessors);
            assert (!MemoryUnit.sum(memoryLimit.values()).isZero());
            this.memoryMapping.put(run, memoryLimit);
            RunFuture futureResult = new RunFuture(run);
            this.assignedRuns.put(run, futureResult);
            AssignRunCommand assignCmd = new AssignRunCommand(run, runCollection.getRunCollection().getId(), selectedProcessors, memoryLimit);
            this.worker.sendCommand(assignCmd);
            return Futures.makeChecked(futureResult, new Function<Exception, RunExecutionAbortedException>(){

                @Override
                public RunExecutionAbortedException apply(Exception input) {
                    if (input instanceof RunExecutionAbortedException) {
                        return (RunExecutionAbortedException)input;
                    }
                    return new RunExecutionAbortedException(input.getMessage(), false);
                }
            });
        }
    }

    private Map<Integer, MemoryUnit> selectMemoryLimitForRun(Run run, Set<Processor> selectedProcessors) {
        Preconditions.checkArgument(!selectedProcessors.isEmpty());
        Optional<MemoryUnit> runMemoryLimit = run.getLimitations().getMemoryLimit();
        MemoryUnit usedMemoryLimit = runMemoryLimit.or(this.getUnreservedMemory());
        ImmutableSet<Integer> usableNodes = FluentIterable.from(selectedProcessors).transform(ProcessorToSocketIdFunction.INSTANCE).toSet();
        ImmutableMap.Builder<Integer, MemoryUnit> result = ImmutableMap.builder();
        MemoryUnit remainingLimit = usedMemoryLimit;
        Map<Integer, MemoryUnit> unreservedNumaMemory = this.getUnreservedNumaMemory();
        for (Map.Entry<Integer, MemoryUnit> unreservedNodeMemory : unreservedNumaMemory.entrySet()) {
            if (!usableNodes.contains(unreservedNodeMemory.getKey())) continue;
            MemoryUnit unreservedMemory = unreservedNodeMemory.getValue();
            MemoryUnit runNodeMemoryLimit = MemoryUnit.min(unreservedMemory, remainingLimit);
            remainingLimit = remainingLimit.minus(runNodeMemoryLimit);
            result.put(unreservedNodeMemory.getKey(), runNodeMemoryLimit);
        }
        Verify.verify(!runMemoryLimit.isPresent() || remainingLimit.isZero(), "Unassigned memory limit: " + remainingLimit, new Object[0]);
        return result.build();
    }

    private ImmutableSet<Processor> selectProcessors(Run run, ScheduledRequirements requirements) {
        Optional<Integer> processorLimit = run.getLimitations().getProcessorLimit();
        int actualProcessorLimit = processorLimit.or(requirements.getProcessorRequirements());
        Optional<MemoryUnit> memoryLimit = run.getLimitations().getMemoryLimit();
        MemoryUnit actualMemoryLimit = memoryLimit.or(requirements.getMemoryRequirements()).or(MemoryUnit.bytes(1L));
        ImmutableSet<Processor> unreservedProcessors = this.getUnreservedCores();
        Map<Integer, MemoryUnit> availableNumaMemory = this.getUnreservedNumaMemory();
        Map<Integer, Integer> socketToUsabelProcessorCount = ProcessorsToSocketToNumOfProcessor.INSTANCE.apply((Set<Processor>)unreservedProcessors);
        Set<Set<Integer>> powerSetOfSockets = Sets.powerSet(socketToUsabelProcessorCount.keySet());
        Set usableSockets = (Set)FluentIterable.from(powerSetOfSockets).filter(new EnoughAvailablProcessorsOnNodes(actualProcessorLimit, socketToUsabelProcessorCount)).filter(new EnoughAvailablMemoryOnNodes(actualMemoryLimit, availableNumaMemory)).toSortedList(SetSizeComparator.INSTANCE).get(0);
        ImmutableList<Processor> sortedUsableProcesors = FluentIterable.from(unreservedProcessors).filter(new ProcessorsOnUsableNodes(usableSockets)).toSortedList(CoreComparator.INSTANCE);
        return FluentIterable.from(sortedUsableProcesors).limit(actualProcessorLimit).toSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRunResult(RunResult runResult) {
        Run run = runResult.getRun();
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            Preconditions.checkArgument(this.assignedRuns.containsKey(run), "%s got %s for unassigned run %s", this, runResult, run);
            this.memoryMapping.remove(run);
            this.processorMappings.removeAll(run);
            this.assignedRuns.remove(run).set(runResult);
            this.currentlyUnreservedProcessors = Optional.absent();
        }
        this.worker.sendCommand(new FinishRunCommand(run));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRunAborted(Run run, @Nullable RunExecutionAbortedException reason) {
        Preconditions.checkNotNull(run);
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            if (this.assignedRuns.containsKey(run)) {
                this.memoryMapping.remove(run);
                this.processorMappings.removeAll(run);
                this.assignedRuns.remove(run).setException(reason);
                this.currentlyUnreservedProcessors = Optional.absent();
            } else {
                this.logger.logf(Level.WARNING, "%s got abort command for %s, but no run is set. Could be caused by race condition.", this, run);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllRunsAborted(@Nullable RunExecutionAbortedException reason) {
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            for (Run run : this.assignedRuns.keySet()) {
                this.assignedRuns.get(run).setException(reason);
            }
            this.assignedRuns.clear();
            this.memoryMapping.clear();
            this.processorMappings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingUnitSnapshot getSnapshot() {
        Object object = this.processingUnitSynchronization;
        synchronized (object) {
            return new DefaultProcessingUnitSnapshot();
        }
    }

    @Override
    public int compareTo(ProcessingUnit o) {
        if (!(o instanceof DefaultProcessingUnit)) {
            return 0;
        }
        DefaultProcessingUnit other = (DefaultProcessingUnit)o;
        return ComparisonChain.start().compare(this.getUnreservedCoreCount(), other.getUnreservedCoreCount()).compare(this.getUnreservedMemory(), other.getUnreservedMemory()).result();
    }

    public int hashCode() {
        return this.worker.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProcessingUnit)) {
            return false;
        }
        return this.compareTo((ProcessingUnit)obj) == 0;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.worker.toString());
    }

    @Override
    public String toLongString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("worker", this.worker).add("workerState", (Object)this.worker.getState()).add("workerRuntimeInformation", this.worker.getRuntimeInformation()).add("workerSummary", this.worker.getWorkerSummary()).add("processorMappings", this.processorMappings).add("memoryMappings", this.memoryMapping).add("currentlyUnreservedProcessors", this.currentlyUnreservedProcessors.orNull()).toString();
    }

    private final class DefaultProcessingUnitSnapshot
    implements ProcessingUnitSnapshot {
        private final int unreservedCoreCount;
        private final MemoryUnit unreservedMemory;
        private final int reservedCoreCount;
        private final MemoryUnit reservedMemory;

        private DefaultProcessingUnitSnapshot() {
            this.unreservedCoreCount = DefaultProcessingUnit.this.getUnreservedCoreCount();
            this.unreservedMemory = DefaultProcessingUnit.this.getUnreservedMemory();
            this.reservedCoreCount = DefaultProcessingUnit.this.getNumberOfReservedProcessors();
            this.reservedMemory = DefaultProcessingUnit.this.getReservedMemory();
        }

        @Override
        public int compareTo(ProcessingUnitSnapshot o) {
            if (!(o instanceof DefaultProcessingUnitSnapshot)) {
                return 0;
            }
            DefaultProcessingUnitSnapshot other = (DefaultProcessingUnitSnapshot)o;
            return ComparisonChain.start().compare(this.unreservedCoreCount, other.unreservedCoreCount).compare(this.unreservedMemory, other.unreservedMemory).result();
        }

        public int hashCode() {
            return Objects.hash(this.unreservedCoreCount, this.unreservedMemory);
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProcessingUnitSnapshot)) {
                return false;
            }
            return this.compareTo((ProcessingUnitSnapshot)other) == 0;
        }

        @Override
        public ProcessingUnit getProcessingUnit() {
            return DefaultProcessingUnit.this;
        }

        @Override
        public MemoryUnit getReservedMemory() {
            return this.reservedMemory;
        }

        @Override
        public int getReservedCoreCount() {
            return this.reservedCoreCount;
        }
    }

    private class RunFuture
    extends AbstractFuture<RunResult> {
        private final Run run;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private RunFuture(Run run) {
            this.run = Preconditions.checkNotNull(run);
        }

        @Override
        protected boolean set(RunResult result) {
            Preconditions.checkState(result.getRun().equals(this.run), "RunResult %s is no match for %s.", result, this.run);
            return super.set(Preconditions.checkNotNull(result));
        }

        @Override
        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        @Override
        public boolean cancel(boolean ignored) {
            if (super.isDone()) {
                return false;
            }
            DefaultProcessingUnit.this.worker.sendCommand(new CancelRunCommand(this.run));
            this.cancelled.set(true);
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }

    private static class ProcessorsOnUsableNodes
    implements Predicate<Processor> {
        private final Set<Integer> usableSockets;

        private ProcessorsOnUsableNodes(Set<Integer> usableSockets) {
            this.usableSockets = usableSockets;
        }

        @Override
        public boolean apply(Processor processor) {
            return this.usableSockets.contains(processor.getSocketId());
        }
    }
}

