/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ConnectionAcceptor;
import org.sosy_lab.verifiercloud.global.networking.establishing.server.ServerInitializationException;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.SyncIncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.networking.Server;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnit;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnitSnapshot;
import org.sosy_lab.verifiercloud.master.workerside.WorkerAbstraction;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPool;
import org.sosy_lab.verifiercloud.master.workerside.WorkerPoolListener;
import org.sosy_lab.verifiercloud.master.workerside.WorkerToMasterAPI;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerDispatcher;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerStarter;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessingUnitSnapshotExtractor;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.SnapshotToProcessingUnit;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.TrueIfFreeCapacityPredicate;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.WorkerAbstractionToProcessingUnitFunction;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.WorkerEqualityPredicate;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.WorkerFinishedInitializationPredicate;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.WorkerStartedPredicate;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.WorkerSummaryFunction;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.RequestWorkerStateCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class DefaultWorkerPool
implements WorkerPool {
    private static final TimeInterval STATE_REQUEST_INTERVAL = Constants.WORKER_STATE_REQUEST_INTERVAL;
    private static final TimeInterval LIVENESS_CRITERIUM = TimeInterval.seconds(STATE_REQUEST_INTERVAL.toSeconds() * 15L);
    private final Logger logger;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Collection<WorkerAbstraction> workers = Lists.newCopyOnWriteArrayList();
    private final IncomingCommandHandler<WorkerToMasterAPI> incQueue;
    private final Collection<WorkerPoolListener> workerPoolListeners = Lists.newCopyOnWriteArrayList();
    private final Server server;
    private final Timer heartbeatTimer = new Timer("WorkerPoolHeartbeatTimer", true);
    private final WorkerDispatcher workerDispatcher;

    @Inject
    public DefaultWorkerPool(WorkerToMasterAPI api, WorkerStarter workerStarter, SystemInformationProvider sysInfoProvider, WorkerDispatcher workerDispatcher, @Named(value="worker-to-master-port") Integer workerToMasterPort, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler);
        this.server = new Server(workerToMasterPort, new WorkerConnectionAcceptor(), uncaughtExceptionHandler, logger);
        this.incQueue = new SyncIncomingCommandHandler<WorkerToMasterAPI>(api, logger);
        this.workerDispatcher = workerDispatcher;
    }

    @Override
    public void addWorkerPoolListener(WorkerPoolListener workerPoolListener) {
        this.workerPoolListeners.add(Preconditions.checkNotNull(workerPoolListener));
    }

    @Override
    public void startProcessingAndInitializeWorkers(Collection<WorkerStartInformation> workerHosts) throws ServerInitializationException {
        this.incQueue.start();
        this.server.startServer();
        this.workerDispatcher.start(Preconditions.checkNotNull(workerHosts));
        this.heartbeatTimer.scheduleAtFixedRate((TimerTask)new RequestStateTask(), 0L, STATE_REQUEST_INTERVAL.toMilliseconds());
        this.heartbeatTimer.scheduleAtFixedRate((TimerTask)new CheckLivenessTask(), 0L, STATE_REQUEST_INTERVAL.toMilliseconds());
    }

    @Override
    public void stopProcessingAndKillWorkers() {
        this.workerDispatcher.stop();
        this.server.stopServer();
        for (WorkerAbstraction worker : this.workers) {
            worker.stopWorker();
        }
        this.heartbeatTimer.cancel();
        long timeToStopMillis = System.currentTimeMillis() + 10000L;
        while (timeToStopMillis > System.currentTimeMillis() && !this.workers.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        for (WorkerAbstraction worker : this.workers) {
            worker.terminateCommunication();
        }
        this.incQueue.stop();
    }

    @Override
    public ImmutableList<ProcessingUnit> getProcessingUnitsWithFreeCapacity() {
        ImmutableList<ProcessingUnitSnapshot> sortedList = FluentIterable.from(this.workers).filter(WorkerFinishedInitializationPredicate.INSTANCE).transform(WorkerAbstractionToProcessingUnitFunction.INSTANCE).filter(TrueIfFreeCapacityPredicate.INSTANCE).transform(ProcessingUnitSnapshotExtractor.INSTANCE).toSortedList(Ordering.natural());
        return FluentIterable.from(sortedList).transform(SnapshotToProcessingUnit.INSTANCE).toList();
    }

    @Override
    public ImmutableCollection<ProcessingUnit> getAllProcessingUnits() {
        return FluentIterable.from(this.workers).filter(WorkerStartedPredicate.INSTANCE).transform(WorkerAbstractionToProcessingUnitFunction.INSTANCE).toList();
    }

    @Override
    public ImmutableList<WorkerSummary> getWorkerSummaries() {
        return FluentIterable.from(this.workers).filter(WorkerStartedPredicate.INSTANCE).transform(new WorkerSummaryFunction()).toList();
    }

    @Override
    public void addWorker(WorkerStartInformation workerStartInformation) {
        this.workerDispatcher.addHost(Preconditions.checkNotNull(workerStartInformation));
    }

    @Override
    public boolean removeWorker(String hostname) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostname));
        boolean workerMatched = this.workerDispatcher.removeAvailableHost(hostname);
        Collection<WorkerAbstraction> activeWorkerOnHost = Collections2.filter(this.workers, new WorkerEqualityPredicate(hostname));
        for (WorkerAbstraction worker : activeWorkerOnHost) {
            if (worker.getWorkerId().isPresent()) {
                String workerId = worker.getWorkerId().get();
                this.workerDispatcher.removeAvailableHost(workerId);
            }
            worker.stopWorker();
            workerMatched = true;
        }
        return workerMatched;
    }

    @Override
    public ImmutableList<String> getAvailableHosts() {
        return this.workerDispatcher.availableHosts();
    }

    private class WorkerListener
    implements WorkerAbstraction.WorkerEventListener {
        private WorkerListener() {
        }

        @Override
        public void newCommand(WorkerAbstraction worker, WorkerToMasterCommand cmd) {
            DefaultWorkerPool.this.incQueue.addCommand(worker, cmd);
        }

        @Override
        public void workerStateChanged(WorkerAbstraction worker, boolean additionalResourceFree, ExternalWorkerState oldState) {
            switch (worker.getState()) {
                case DEACTIVATED: {
                    this.workerDeactivated(worker, oldState);
                    break;
                }
                case INITIALIZING: 
                case USER_OCCUPIED: 
                case AVAILABLE: 
                case STOPPING: {
                    for (WorkerPoolListener listener : DefaultWorkerPool.this.workerPoolListeners) {
                        listener.processingUnitStateChanged(worker.getProcessingUnit(), additionalResourceFree);
                    }
                    break;
                }
                case ERROR: {
                    worker.stopWorker();
                    break;
                }
                default: {
                    throw new RuntimeException("Missing state " + (Object)((Object)worker.getState()));
                }
            }
        }

        private void workerDeactivated(WorkerAbstraction worker, ExternalWorkerState oldState) {
            DefaultWorkerPool.this.workers.remove(worker);
            if (oldState != ExternalWorkerState.STARTING) {
                String hostname = worker.getHostInformation().getHostname();
                FluentIterable<WorkerAbstraction> workersWithEqualHostname = FluentIterable.from(DefaultWorkerPool.this.workers).filter(new WorkerEqualityPredicate(hostname));
                if (workersWithEqualHostname.isEmpty()) {
                    if (worker.getWorkerId().isPresent()) {
                        DefaultWorkerPool.this.workerDispatcher.setHostStatus(worker.getWorkerId().get(), false);
                    }
                    DefaultWorkerPool.this.logger.logf(Level.FINEST, "Current number of workers: %d", DefaultWorkerPool.this.workers.size());
                    for (WorkerPoolListener listener : DefaultWorkerPool.this.workerPoolListeners) {
                        listener.processingUnitUnavailable(worker.getProcessingUnit());
                    }
                }
            }
        }

        @Override
        public void workerStarted(WorkerAbstraction startedWorker) {
            Preconditions.checkArgument(startedWorker.getState() != ExternalWorkerState.STARTING);
            HostInformation info = Preconditions.checkNotNull(startedWorker.getHostInformation());
            String newHostname = info.getHostname();
            FluentIterable<WorkerAbstraction> workersWithNewHostname = FluentIterable.from(DefaultWorkerPool.this.workers).filter(new WorkerEqualityPredicate(newHostname));
            if (workersWithNewHostname.size() > 1) {
                DefaultWorkerPool.this.logger.logf(Level.WARNING, "Stopping second worker running on %s. ", newHostname);
                startedWorker.stopWorker();
                return;
            }
            if (startedWorker.getWorkerId().isPresent()) {
                DefaultWorkerPool.this.workerDispatcher.setHostStatus(startedWorker.getWorkerId().get(), true);
            }
            DefaultWorkerPool.this.logger.logf(Level.INFO, "Worker ready: %s@%s -- %s [%d processors, %s memory]", info.getUser(), info.getHostname(), info.getCPUName(), info.getNumberOfProcessors(), info.getTotalMemory());
            for (WorkerPoolListener listener : DefaultWorkerPool.this.workerPoolListeners) {
                listener.processingUnitAvailable();
            }
        }
    }

    private class CheckLivenessTask
    extends TimerTask {
        private CheckLivenessTask() {
        }

        @Override
        public void run() {
            for (WorkerAbstraction worker : DefaultWorkerPool.this.workers) {
                TimeInterval timeSinceUpdate = worker.getTimeSinceLastUpdate();
                if (worker.isStarted() && worker.isAlive()) {
                    if (timeSinceUpdate.compareTo(LIVENESS_CRITERIUM) <= 0) continue;
                    DefaultWorkerPool.this.logger.logf(Level.WARNING, "Stopping %s due to response time out. No update for %s.", worker, timeSinceUpdate);
                    worker.stopWorker();
                    worker.terminateCommunication();
                    continue;
                }
                if (worker.isStarted() || timeSinceUpdate.compareTo(LIVENESS_CRITERIUM) <= 0) continue;
                DefaultWorkerPool.this.logger.logf(Level.WARNING, "Stopping uninitialized %s due to response time out. No update for %s.", worker, timeSinceUpdate);
                worker.stopWorker();
                worker.terminateCommunication();
            }
        }
    }

    private class RequestStateTask
    extends TimerTask {
        private RequestStateTask() {
        }

        @Override
        public void run() {
            for (WorkerAbstraction worker : DefaultWorkerPool.this.workers) {
                if (!worker.isStarted()) continue;
                worker.sendCommand(new RequestWorkerStateCommand());
            }
        }
    }

    private class WorkerConnectionAcceptor
    implements ConnectionAcceptor {
        private WorkerConnectionAcceptor() {
        }

        @Override
        public void acceptSocket(Socket clientSocket) {
            LinkedList<WorkerAbstraction.WorkerEventListener> workerListeners = Lists.newLinkedList();
            workerListeners.add(new WorkerListener());
            WorkerAbstraction worker = new WorkerAbstraction(clientSocket, DefaultWorkerPool.this.incQueue, DefaultWorkerPool.this.logger, DefaultWorkerPool.this.uncaughtExceptionHandler, workerListeners);
            worker.startCommunication();
            DefaultWorkerPool.this.workers.add(worker);
        }
    }
}

