/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.hash.HashCode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.files.ConcurrentMasterFileStorage;
import org.sosy_lab.verifiercloud.master.workerside.RunExecutionAbortedException;
import org.sosy_lab.verifiercloud.master.workerside.WorkerAbstraction;
import org.sosy_lab.verifiercloud.master.workerside.WorkerCrashReportWriter;
import org.sosy_lab.verifiercloud.master.workerside.WorkerToMasterAPI;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.FileNotAvailableCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.RequestResultFileCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.SendFileCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.WorkerCompleteInitializationCommand;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;

public class DefaultWorkerToMasterAPI
implements WorkerToMasterAPI {
    private final Logger logger;
    private final ApplicationService master;
    private final ConcurrentMasterFileStorage fileStorage;
    private final WorkerCrashReportWriter workerCrashReportWriter;
    private final Map<Run, RunResult> pendingRunResults = MapConstraints.constrainedMap(new HashMap(), new MapConstraint<Run, RunResult>(){

        @Override
        public void checkKeyValue(Run run, RunResult runResult) {
            Preconditions.checkArgument(runResult.getRun().equals(run));
        }
    });

    @Inject
    public DefaultWorkerToMasterAPI(Logger logger, ApplicationService master, ConcurrentMasterFileStorage fileStorage, WorkerCrashReportWriter workerCrashReportWriter) {
        this.master = master;
        this.logger = Preconditions.checkNotNull(logger);
        this.fileStorage = Preconditions.checkNotNull(fileStorage);
        this.workerCrashReportWriter = Preconditions.checkNotNull(workerCrashReportWriter);
    }

    @Override
    public void workerStarted(WorkerAbstraction worker, HostInformation hostInformation, Optional<String> workerId, ExecutorState executorState, WorkerRuntimeInformation workerRuntimeInformation) {
        if (worker.isStarted()) {
            this.logger.logf(Level.WARNING, "%s is trying to initialize, but is already initialized. Sending stop command.", worker);
            worker.stopWorker();
            return;
        }
        worker.workerStarted(Preconditions.checkNotNull(hostInformation), Preconditions.checkNotNull(executorState), Preconditions.checkNotNull(workerId), Preconditions.checkNotNull(workerRuntimeInformation));
        worker.sendCommand(new WorkerCompleteInitializationCommand());
    }

    @Override
    public void updateWorkerState(WorkerAbstraction worker, ExecutorState executorState, WorkerRuntimeInformation workerRuntimeInformation) {
        Preconditions.checkNotNull(worker);
        Preconditions.checkNotNull(executorState);
        if (!worker.isStarted()) {
            this.logger.logf(Level.WARNING, "%s is trying to update worker state on uninitialized Worker.", worker);
            return;
        }
        worker.updateState(executorState, workerRuntimeInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rejectRun(WorkerAbstraction worker, Run run, String reason, boolean error) {
        Preconditions.checkNotNull(worker);
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(reason);
        Map<Run, RunResult> map = this.pendingRunResults;
        synchronized (map) {
            this.pendingRunResults.remove(run);
        }
        RunExecutionAbortedException abortException = new RunExecutionAbortedException(reason, error);
        worker.getProcessingUnit().setRunAborted(run, abortException);
        this.logger.logf(Level.INFO, "%s rejected %s: %s", worker, run, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResults(WorkerAbstraction worker, Run run, RunResult runResult) {
        Preconditions.checkNotNull(worker);
        Preconditions.checkNotNull(run);
        Preconditions.checkNotNull(runResult);
        Preconditions.checkArgument(runResult.getRun().equals(run));
        this.logger.logf(Level.FINE, "Received result for %s from %s.", run, worker);
        Map<Run, RunResult> map = this.pendingRunResults;
        synchronized (map) {
            this.pendingRunResults.put(run, runResult);
            this.finishRunOrRequestFile(worker, run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRunOrRequestFile(WorkerAbstraction worker, Run run) {
        Map<Run, RunResult> map = this.pendingRunResults;
        synchronized (map) {
            if (!this.pendingRunResults.containsKey(run)) {
                return;
            }
            RunResult runResult = this.pendingRunResults.get(run);
            Preconditions.checkState(runResult.getRun().equals(run));
            Optional<HashCode> missingFile = this.stillMissingFileHash(runResult.getResultFiles());
            if (missingFile.isPresent()) {
                worker.sendCommand(new RequestResultFileCommand(run, missingFile.get()));
            } else {
                worker.getProcessingUnit().setRunResult(runResult);
                this.pendingRunResults.remove(run);
            }
        }
    }

    @Override
    public void sendFile(WorkerAbstraction worker, Run run, FileContent file) {
        this.logger.logf(Level.FINEST, "Received the file %s from %s", file.getFileHash(), worker);
        try {
            this.fileStorage.addFile(file);
        }
        catch (IOException e) {
            this.logger.logf(Level.SEVERE, "IOException when writing to file storage: %s", e.getMessage());
            RunExecutionAbortedException abortException = new RunExecutionAbortedException(e.getMessage(), true);
            worker.getProcessingUnit().setRunAborted(run, abortException);
        }
        this.finishRunOrRequestFile(worker, run);
    }

    private Optional<HashCode> stillMissingFileHash(Collection<FileAtRelativePath> files) {
        for (FileAtRelativePath relativePath : files) {
            if (this.fileStorage.isFileKnown(relativePath.getFileHash())) continue;
            return Optional.of(relativePath.getFileHash());
        }
        return Optional.absent();
    }

    @Override
    public void requestFile(final WorkerAbstraction worker, final HashCode fileHash) {
        Preconditions.checkNotNull(worker);
        Preconditions.checkNotNull(fileHash);
        ListenableFuture<FileContent> fileContentFuture = this.fileStorage.getFileContent(fileHash);
        Futures.addCallback(fileContentFuture, new FutureCallback<FileContent>(){

            @Override
            public void onSuccess(FileContent result) {
                worker.sendCommand(new SendFileCommand(result));
                DefaultWorkerToMasterAPI.this.logger.logf(Level.FINEST, "Sent file %s to %s.", fileHash, worker);
            }

            @Override
            public void onFailure(Throwable t) {
                DefaultWorkerToMasterAPI.this.logger.logf(Level.SEVERE, t, "File with hash %s is not available, but requested by %s.", fileHash, worker);
                worker.sendCommand(new FileNotAvailableCommand(fileHash));
                DefaultWorkerToMasterAPI.this.master.stop();
            }
        });
    }

    @Override
    public void reportWorkerCrash(WorkerAbstraction worker, FileContent crashReport) {
        this.workerCrashReportWriter.write(worker, crashReport);
    }
}

