/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.networking.interaction.ConnectionListener;
import org.sosy_lab.verifiercloud.global.networking.interaction.IncomingCommandHandler;
import org.sosy_lab.verifiercloud.global.networking.interaction.NetworkAbstraction;
import org.sosy_lab.verifiercloud.master.workerside.DefaultProcessingUnit;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnit;
import org.sosy_lab.verifiercloud.master.workerside.ProcessingUnitSnapshot;
import org.sosy_lab.verifiercloud.master.workerside.RunExecutionAbortedException;
import org.sosy_lab.verifiercloud.master.workerside.WorkerToMasterAPI;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessorsToMaxCountPerSocket;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.MasterToWorkerCommand;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.StopWorkerCommand;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerState;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class WorkerAbstraction
extends NetworkAbstraction<WorkerToMasterCommand, MasterToWorkerCommand, WorkerToMasterAPI> {
    private static final Level LOG_LEVEL_WORKER = Level.FINE;
    private static final Level LOG_LEVEL_PARTITIONS = Level.FINER;
    private final Logger logger;
    private final List<WorkerEventListener> listeners = Collections.synchronizedList(new LinkedList());
    private final ProcessingUnit processingUnit;
    private volatile Optional<HostInformation> hostInfo = Optional.absent();
    private volatile Optional<Optional<String>> workerId = Optional.absent();
    private volatile ExternalWorkerState workerState = ExternalWorkerState.STARTING;
    private volatile Optional<ExecutorState> executorState = Optional.absent();
    private volatile Optional<WorkerRuntimeInformation> workerRuntimeInformation = Optional.absent();
    private volatile MemoryUnit lastFreeMemory = MemoryUnit.zero();
    private transient Optional<Integer> maxUsableCoreCountPerSocket = Optional.absent();
    private final AtomicBoolean workerStopped = new AtomicBoolean(false);
    private volatile long lastUpdate = System.currentTimeMillis();

    public WorkerAbstraction(Socket workerSocket, IncomingCommandHandler<WorkerToMasterAPI> incQueue, Logger logger, Thread.UncaughtExceptionHandler exceptionHandler, List<WorkerEventListener> listeners) {
        super(workerSocket, exceptionHandler, logger, WorkerToMasterCommand.class);
        this.logger = Preconditions.checkNotNull(logger);
        this.processingUnit = new DefaultProcessingUnit(this, logger);
        this.listeners.addAll(listeners);
        this.addConnectionListener(new WorkerConnectionListener(incQueue));
    }

    public boolean isStarted() {
        return this.workerState != ExternalWorkerState.STARTING;
    }

    public boolean finishedInitialization() {
        ExternalWorkerState currentWorkerState = this.workerState;
        return currentWorkerState != ExternalWorkerState.STARTING && currentWorkerState != ExternalWorkerState.INITIALIZING;
    }

    public synchronized void workerStarted(HostInformation hostInfo, ExecutorState initialState, Optional<String> workerId, WorkerRuntimeInformation workerRuntimeInformation) {
        if (this.workerState != ExternalWorkerState.STARTING) {
            this.logger.logf(Level.WARNING, "Must not be called when state is %s.", new Object[]{this.workerState});
            this.stopWorker();
            this.terminateCommunication();
        }
        Preconditions.checkState(!this.hostInfo.isPresent());
        this.hostInfo = Optional.of(hostInfo);
        Preconditions.checkState(!this.workerId.isPresent());
        this.workerId = Optional.of(workerId);
        Preconditions.checkNotNull(initialState);
        Preconditions.checkArgument(initialState.getPartitions().isEmpty());
        this.workerRuntimeInformation = Optional.of(workerRuntimeInformation);
        this.updateState(workerRuntimeInformation.getState(), initialState, true);
    }

    public boolean isStopped() {
        return this.workerStopped.get();
    }

    public void stopWorker() {
        this.workerStopped.set(true);
        this.sendCommand(new StopWorkerCommand());
    }

    @Override
    public void terminateCommunication() {
        super.terminateCommunication();
        this.workerStopped.set(true);
        this.setStateDeactivate();
    }

    private void setStateDeactivate() {
        ExecutorState procState = this.executorState.isPresent() ? this.executorState.get() : ExecutorState.emptyExecutorState();
        this.setWorkerState(ExternalWorkerState.DEACTIVATED, procState, false);
        RunExecutionAbortedException reason = new RunExecutionAbortedException("Worker is deactivated.", false);
        this.processingUnit.setAllRunsAborted(reason);
    }

    public ExternalWorkerState getState() {
        return this.workerState;
    }

    public synchronized void updateState(ExecutorState executorState, WorkerRuntimeInformation workerRuntimeInformation) {
        this.workerRuntimeInformation = Optional.of(workerRuntimeInformation);
        this.maxUsableCoreCountPerSocket = Optional.absent();
        this.lastUpdate = System.currentTimeMillis();
        boolean additionalResourceFree = this.isAddtionalRecourceFree(workerRuntimeInformation, executorState);
        this.updateState(workerRuntimeInformation.getState(), executorState, additionalResourceFree);
    }

    private void updateState(WorkerState workerState, ExecutorState executorState, boolean additionalResourceFree) {
        ExternalWorkerState newState;
        Preconditions.checkState(this.workerRuntimeInformation.isPresent());
        Preconditions.checkState(this.hostInfo.isPresent());
        block0 : switch (this.workerState) {
            case DEACTIVATED: {
                newState = ExternalWorkerState.DEACTIVATED;
                break;
            }
            default: {
                switch (workerState) {
                    case INITIALIZING: {
                        newState = ExternalWorkerState.INITIALIZING;
                        break block0;
                    }
                    case AVAILABLE: {
                        newState = ExternalWorkerState.AVAILABLE;
                        break block0;
                    }
                    case USER_OCCUPIED: {
                        newState = ExternalWorkerState.USER_OCCUPIED;
                        break block0;
                    }
                    case ERROR: {
                        newState = ExternalWorkerState.ERROR;
                        break block0;
                    }
                    case STOPPING: {
                        newState = ExternalWorkerState.STOPPING;
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown state.");
            }
        }
        this.setWorkerState(newState, executorState, additionalResourceFree);
    }

    private void checkInitializationComplete() throws IllegalStateException {
        Preconditions.checkState(this.getState() != ExternalWorkerState.STARTING, "%s is not yet initialized.", this);
        Preconditions.checkState(this.hostInfo.isPresent());
        Preconditions.checkState(this.workerRuntimeInformation.isPresent());
        Preconditions.checkState(this.executorState.isPresent());
        Preconditions.checkState(this.workerId.isPresent());
    }

    private synchronized void setWorkerState(ExternalWorkerState state, ExecutorState procState, boolean additionalResourceFree) {
        boolean executorStateChanged;
        Preconditions.checkNotNull(state);
        Preconditions.checkNotNull(procState);
        ExternalWorkerState oldState = this.workerState;
        boolean workerStarted = this.workerState == ExternalWorkerState.STARTING && state != ExternalWorkerState.STARTING && state != ExternalWorkerState.DEACTIVATED;
        boolean workerStateChanged = state != this.workerState;
        boolean bl = executorStateChanged = !this.executorState.isPresent() || !procState.equals(this.executorState.get());
        if (workerStateChanged || executorStateChanged || additionalResourceFree) {
            this.executorState = Optional.of(procState);
            this.workerState = state;
            if (this.logger.wouldLog(LOG_LEVEL_WORKER)) {
                if (workerStateChanged || executorStateChanged) {
                    String stateDescription = this.logger.wouldLog(LOG_LEVEL_PARTITIONS) && !procState.getPartitions().isEmpty() ? state.toString() + " " + procState : state.toString();
                    this.logger.logf(workerStateChanged ? LOG_LEVEL_WORKER : LOG_LEVEL_PARTITIONS, "%s state changed to %s.", this, stateDescription);
                } else if (additionalResourceFree) {
                    this.logger.logf(workerStateChanged ? LOG_LEVEL_WORKER : LOG_LEVEL_PARTITIONS, "%s freed recources.", this);
                }
            }
            for (WorkerEventListener listener : this.listeners) {
                if (workerStarted) {
                    listener.workerStarted(this);
                }
                listener.workerStateChanged(this, additionalResourceFree, oldState);
            }
        }
    }

    private boolean isAddtionalRecourceFree(WorkerRuntimeInformation workerRuntimeInformation, ExecutorState procState) {
        MemoryUnit now = MemoryUnit.min(workerRuntimeInformation.getFreeMemory(), this.processingUnit.getUnreservedMemory());
        boolean available = workerRuntimeInformation.getState() == WorkerState.AVAILABLE;
        boolean moreFreeMemory = now.compareTo(this.lastFreeMemory) > 0;
        boolean lessRuns = !this.executorState.isPresent() || procState.getNumberOfPartitions() < this.executorState.get().getNumberOfPartitions();
        boolean previouslyNotReady = this.workerState != ExternalWorkerState.AVAILABLE;
        boolean additionalResourceFree = available && (previouslyNotReady || lessRuns || moreFreeMemory);
        this.lastFreeMemory = now;
        this.logger.logf(Level.ALL, "Usable memory on %s: %s", this, now);
        return additionalResourceFree;
    }

    public TimeInterval getTimeSinceLastUpdate() {
        return TimeInterval.milliseconds(System.currentTimeMillis() - this.lastUpdate);
    }

    public boolean canSatisfyRequirements(Requirements requirements) {
        this.checkInitializationComplete();
        HostInformation hostInformation = this.getHostInformation();
        WorkerRuntimeInformation currentWorkerRuntimeInformation = this.getRuntimeInformation();
        ImmutableSet<Processor> useableProcessors = this.getUsableProcessors(currentWorkerRuntimeInformation);
        int maxUsableCoresPerSocket = this.getMaxUsableCoreCountPerSocket();
        return requirements.isSatisfiedBy(currentWorkerRuntimeInformation.getFreeMemory(), currentWorkerRuntimeInformation.getFreeNumaMemory(), useableProcessors, maxUsableCoresPerSocket, hostInformation);
    }

    private ImmutableSet<Processor> getUsableProcessors(WorkerRuntimeInformation currentWorkerRuntimeInformation) {
        ImmutableSet<Processor> allProcessors = this.getHostInformation().getProcessors();
        ImmutableSet<Processor> unusableProcessors = currentWorkerRuntimeInformation.getUnusableProcessors();
        ImmutableSet<Processor> usableProcessors = unusableProcessors.isEmpty() ? allProcessors : FluentIterable.from(allProcessors).filter(Predicates.not(Predicates.in(unusableProcessors))).toSet();
        return usableProcessors;
    }

    public HostInformation getHostInformation() {
        this.checkInitializationComplete();
        return this.hostInfo.get();
    }

    public WorkerRuntimeInformation getRuntimeInformation() {
        this.checkInitializationComplete();
        return this.workerRuntimeInformation.get();
    }

    public int getMaxUsableCoreCountPerSocket() {
        if (this.maxUsableCoreCountPerSocket.isPresent()) {
            return this.maxUsableCoreCountPerSocket.get();
        }
        ImmutableSet<Processor> usableProcessors = this.getUsableProcessors(this.workerRuntimeInformation.get());
        int maxUsableCoreCountPerSocket = ProcessorsToMaxCountPerSocket.INSTANCE.apply((Set<Processor>)usableProcessors);
        this.maxUsableCoreCountPerSocket = Optional.of(maxUsableCoreCountPerSocket);
        return maxUsableCoreCountPerSocket;
    }

    public Optional<String> getWorkerId() {
        this.checkInitializationComplete();
        return this.workerId.get();
    }

    public ProcessingUnit getProcessingUnit() {
        return this.processingUnit;
    }

    public synchronized WorkerSummary getWorkerSummary() {
        this.checkInitializationComplete();
        ProcessingUnitSnapshot snapshot = this.processingUnit.getSnapshot();
        MemoryUnit reservedMemory = snapshot.getReservedMemory();
        int reservedProcessors = snapshot.getReservedCoreCount();
        return new WorkerSummary(this.workerState, this.workerId.get(), this.executorState.get(), this.hostInfo.get(), this.workerRuntimeInformation.get(), reservedMemory, reservedProcessors);
    }

    public String toString() {
        if (this.hostInfo.isPresent()) {
            return "Worker[" + this.hostInfo.get().getHostname() + "]";
        }
        return "Worker[?]";
    }

    public static interface WorkerEventListener {
        public void workerStateChanged(WorkerAbstraction var1, boolean var2, ExternalWorkerState var3);

        public void workerStarted(WorkerAbstraction var1);

        public void newCommand(WorkerAbstraction var1, WorkerToMasterCommand var2);
    }

    private class WorkerConnectionListener
    implements ConnectionListener<WorkerToMasterCommand> {
        private final IncomingCommandHandler<WorkerToMasterAPI> incomingCommandHandler;

        private WorkerConnectionListener(IncomingCommandHandler<WorkerToMasterAPI> incQueue) {
            this.incomingCommandHandler = Preconditions.checkNotNull(incQueue);
        }

        @Override
        public void connectionClosed() {
            WorkerAbstraction.this.setStateDeactivate();
        }

        @Override
        public void messageReceived(WorkerToMasterCommand message) {
            this.incomingCommandHandler.addCommand(WorkerAbstraction.this, message);
        }
    }
}

